import { BannerGroup } from "./group.js";
import { useBanner } from "../../../contexts/banner.js";
import { GroupList } from "../../common/groups/groupList.js";

import type { FC } from "react";

const BannerGroupList: FC = () => {
    const { groups } = useBanner();
    const useGroups = groups.filter(({ items }) => items.length);

    return (
        <GroupList>
            {useGroups.map((group) => (
                <BannerGroup key={group.id} group={group} />
            ))}
        </GroupList>
    );
};

export { BannerGroupList };
