import { SCALING_WHEN_WINDOW_WIDTH_LOWER, useMatchesMedia } from "@devowl-wp/web-cookie-banner";

import { useBanner } from "../../../contexts/banner.js";
import { useBannerButtonCallbacks } from "../../../hooks/banner/useBannerButtonCallbacks.js";
import { CloseIcon } from "../../closeIcon.js";

import type { FC } from "react";

const BannerCloseIcon: FC = () => {
    const {
        headerDesign: { fontColor, fontSize },
        texts: { acceptEssentials },

        activeAction,
        pageRequestUuid4,
        i18n: { close, closeWithoutSaving },
        buttonClicked = "",
    } = useBanner();
    const { buttonClickedCloseIcon, closeIcon } = useBannerButtonCallbacks();
    const [isMobile] = useMatchesMedia([`(max-width: ${SCALING_WHEN_WINDOW_WIDTH_LOWER}px)`]);

    return (
        <CloseIcon
            width={fontSize}
            color={fontColor}
            tooltipText={activeAction ? (activeAction === "change" ? closeWithoutSaving : close) : acceptEssentials}
            tooltipAlways={isMobile}
            framed={buttonClicked === buttonClickedCloseIcon}
            renderInContainer={document.getElementById(pageRequestUuid4)?.querySelector("dialog")}
            onClick={closeIcon}
        />
    );
};

export { BannerCloseIcon };
