import type { CustomizeSticky } from "@devowl-wp/web-cookie-banner";

import type { FC } from "react";

const BannerStickyIcon: FC<{ type: CustomizeSticky["icon"] | "close" }> = ({ type }) => {
    const svgAttrs = {
        version: "1.1",
        enableBackground: "new 0 0 512 512",
        viewBox: "0 0 512 512",
        fill: "currentColor",
    };

    switch (type) {
        case "custom":
            return <svg {...svgAttrs}></svg>;
        case "close":
            return (
                <svg {...svgAttrs} enableBackground="new 0 0 24 24" viewBox="0 0 24 24">
                    <path d="m4.9902 3.9902a1.0001 1.0001 0 0 0-0.69727 1.7168l6.293 6.293-6.293 6.293a1.0001 1.0001 0 1 0 1.4141 1.4141l6.293-6.293 6.293 6.293a1.0001 1.0001 0 1 0 1.4141-1.4141l-6.293-6.293 6.293-6.293a1.0001 1.0001 0 0 0-0.72656-1.7168 1.0001 1.0001 0 0 0-0.6875 0.30273l-6.293 6.293-6.293-6.293a1.0001 1.0001 0 0 0-0.7168-0.30273z" />
                </svg>
            );
        case "padlock":
            return (
                <svg {...svgAttrs}>
                    <path d="m391.5 210.8v-60.2c0-75.3-60.2-135.5-135.5-135.5s-135.5 60.2-135.5 135.5v60.2c-25.6 0-45.2 19.6-45.2 45.2v195.8c0 25.6 19.6 45.2 45.2 45.2h271.1c25.6 0 45.2-19.6 45.2-45.2v-195.8c-.1-25.6-19.7-45.2-45.3-45.2zm-240.9-60.2c0-58.7 46.7-105.4 105.4-105.4s105.4 46.7 105.4 105.4v60.2h-210.8zm256 301.2c0 9-6 15.1-15.1 15.1h-271c-9 0-15.1-6-15.1-15.1v-195.8c0-9 6-15.1 15.1-15.1h15.1 240.9 15.1c9 0 15.1 6 15.1 15.1v195.8z" />
                    <path d="m256 284.8c-26.1 0-46.1 20-46.1 46.1 0 20 12.3 36.9 30.7 43v33.8c0 9.2 6.1 15.4 15.4 15.4s15.4-6.1 15.4-15.4v-33.8c18.4-6.1 30.7-23 30.7-43 0-26.2-20-46.1-46.1-46.1zm0 61.6c-9 0-15.1-6-15.1-15.1 0-9 6-15.1 15.1-15.1s15.1 6 15.1 15.1c0 9-6.1 15.1-15.1 15.1z" />
                </svg>
            );
        case "incognito":
            return (
                <svg {...svgAttrs}>
                    <path d="m376.3 272c-47.6 0-87.1 34.7-94.7 80.2h-50.6c-7.6-45.5-47.1-80.2-94.7-80.2-53 0-96 43-96 96s43 96 96 96c47.5 0 87-34.5 94.6-79.8h50.7c7.7 45.3 47.1 79.8 94.6 79.8 53 0 96-43 96-96s-42.9-96-95.9-96zm-240 160c-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64-28.6 64-64 64zm240 0c-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64-28.6 64-64 64z" />
                    <path d="m464.3 208.2h-34.9l-24.9-124.2c-4.2-20.9-22.5-36-43.8-36h-208.9c-21 .4-38.9 15.4-43 36l-25.5 124.2h-35c-8.8 0-16 7.2-16 16s7.2 16 16 16h416c8.8 0 16-7.2 16-16 0-8.9-7.1-16-16-16zm-324.9-118c1.2-5.9 6.4-10.2 12.5-10.2h208.8c6.1 0 11.3 4.3 12.5 10.2l23.6 117.8h-281z" />
                </svg>
            );
        default:
            return (
                <svg {...svgAttrs}>
                    <path d="m85.9 98.6c47-43 107.5-66.6 170.1-66.6s123.1 23.6 170.1 66.6c3.1 2.8 6.9 4.2 10.8 4.2 4.4 0 8.7-1.7 11.8-5.2 6-6.5 5.5-16.7-1-22.6-53-48.4-121.1-75-191.7-75s-138.7 26.6-191.7 74.9c-6.5 6-7 16.1-1 22.6 5.9 6.5 16 7 22.6 1.1z" />
                    <path d="m477.3 182.4c-50.4-75-133.1-119.8-221.3-119.8s-170.9 44.8-221.3 119.8c-4.9 7.3-3 17.3 4.4 22.2 7.3 4.9 17.3 3 22.2-4.4 44.4-66.1 117.2-105.6 194.7-105.6s150.3 39.5 194.7 105.6c3.1 4.6 8.1 7.1 13.3 7.1 3.1 0 6.2-.9 8.9-2.7 7.4-4.9 9.3-14.9 4.4-22.2z" />
                    <path d="m140.6 339.5c0-66 51.8-119.7 115.4-119.7s115.4 53.7 115.4 119.7c0 8.8 7.2 16 16 16s16-7.2 16-16c0-83.6-66.1-151.7-147.4-151.7s-147.4 68-147.4 151.7c0 80.6 82 164.3 85.5 167.8 3.1 3.2 7.3 4.7 11.4 4.7s8.1-1.5 11.3-4.6c6.3-6.2 6.3-16.4.1-22.6-.8-.8-76.3-77.8-76.3-145.3z" />
                    <path d="m269.8 125.7c-57-3.8-111.6 15.8-153.7 55.1-43.3 40.6-68.1 98.4-68.1 158.7 0 49.6 16.8 97.9 47.4 136.1 5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5c-26.1-32.5-40.4-73.8-40.4-116.1 0-51.5 21.2-100.8 58.1-135.3 35.6-33.2 81.6-49.8 129.7-46.6 92.1 6.1 164.3 89 164.3 188.7v3.6c0 25.7-20 46.6-44.7 46.6s-44.6-20.9-44.6-46.6v-10.4c0-24.3-9.4-47-26.4-64-16.3-16.2-37.7-25.1-60.4-25.1h-.4c-23.2.1-44.8 10-60.8 27.9-18.4 20.6-27.6 50-24.5 78.9 8.6 81.5 97.9 154.8 136.3 154.8 8.8 0 16-7.1 16-16s-7.2-16-16-16c-21 0-97.5-59.6-104.5-126.1-2.1-20 4.1-40.2 16.6-54.2 7-7.8 19.1-17.2 37.2-17.3h.3c14.1 0 27.6 5.6 37.8 15.8 10.9 10.9 16.9 25.5 16.9 41.3v10.4c0 43.3 34.4 78.6 76.6 78.6s76.7-35.3 76.7-78.6v-3.6c-.2-116.5-85.5-213.4-194.4-220.6z" />
                    <path d="m364.9 446.7c-41.9 0-95.2-56.3-95.2-119.7 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 81.7 69.9 151.7 127.2 151.7 8.8 0 16-7.2 16-16s-7.2-16-16-16z" />
                </svg>
            );
    }
};

export { BannerStickyIcon };
