import { BannerTcfDeclaration } from "./declaration.js";
import { useBanner } from "../../../../contexts/banner.js";
import { useBannerTcfDeclarations } from "../../../../hooks/banner/useBannerTcfDeclarations.js";
import { Group } from "../../../common/groups/group.js";

import type { ComponentProps, FC } from "react";

const BannerTcfDeclarationList: FC<{ declaration: ComponentProps<typeof BannerTcfDeclaration>["declaration"] }> = ({
    declaration,
}) => {
    const banner = useBanner();
    const {
        i18n: {
            tcf: {
                declarations: {
                    [declaration]: { title, desc },
                },
            },
        },
    } = banner;

    const declarations = useBannerTcfDeclarations(declaration);

    return declarations.length > 0 ? (
        <Group headline={title}>
            {desc}
            {declarations.map(({ id }) => (
                <BannerTcfDeclaration key={id} declaration={declaration} id={id} />
            ))}
        </Group>
    ) : null;
};

export { BannerTcfDeclarationList };
