import { Fragment } from "react";

import type { TcfDeclarationFilter } from "@devowl-wp/cookie-consent-web-client";
import { YieldLazyLoad } from "@devowl-wp/react-utils";

import { AsciiSpinner } from "../../asciiSpinner.js";
import { BANNER_GROUP_NON_STANDARD_STYLE } from "../body/body.js";
import { BannerTcfDeclarationList } from "./declarations/list.js";
import { BannerTcfVendorList } from "./vendors/list.js";
import { useBanner } from "../../../contexts/banner.js";
import { GroupButton } from "../../common/groupButton.js";
import { Group } from "../../common/groups/group.js";
import { GroupList } from "../../common/groups/groupList.js";

import type { FC } from "react";

const DECLARATIONS = ["purposes", "specialPurposes", "features", "specialFeatures", "dataCategories"];

const BannerTcfGroupList: FC = () => {
    const banner = useBanner();
    const {
        tcfFilterBy,
        suspense,
        i18n: {
            legitimateInterest,
            consent,
            tcf: { filterText, standard, standardDesc },
        },
        set,
    } = banner;

    return (
        <Fragment>
            <Group headline={standard} style={BANNER_GROUP_NON_STANDARD_STYLE} borderless>
                {standardDesc}
                <div style={BANNER_GROUP_NON_STANDARD_STYLE}>
                    <span aria-hidden>{filterText}</span>&nbsp;
                    <GroupButton
                        legend={filterText}
                        active={tcfFilterBy}
                        onChange={(tcfFilterBy) => set({ tcfFilterBy: tcfFilterBy as TcfDeclarationFilter })}
                        items={[
                            { key: "legInt", value: legitimateInterest },
                            { key: "consent", value: consent },
                        ]}
                    />
                </div>
            </Group>
            <YieldLazyLoad
                promise={suspense.lazyLoadedDataForSecondView}
                suspenseProbs={{ fallback: <AsciiSpinner /> }}
            >
                <GroupList>
                    <BannerTcfVendorList />
                    {DECLARATIONS.map((declaration) => (
                        <BannerTcfDeclarationList key={declaration} declaration={declaration as any} />
                    ))}
                </GroupList>
            </YieldLazyLoad>
        </Fragment>
    );
};

export { BannerTcfGroupList };
