import { BannerTcfVendor } from "./vendor.js";
import { useBanner } from "../../../../contexts/banner.js";
import { useTcfVendors } from "../../../../hooks/tcf/useTcfVendors.js";
import { Group } from "../../../common/groups/group.js";

import type { FC } from "react";

const BannerTcfVendorList: FC = () => {
    const banner = useBanner();
    const {
        tcfFilterBy,
        i18n: {
            tcf: { vendors, filterNoVendors },
        },
    } = banner;

    const useVendors = useTcfVendors(tcfFilterBy);

    const hasVendors = useVendors.length > 0;

    return (
        <Group headline={vendors}>
            {useVendors.map(({ id }) => (
                <BannerTcfVendor key={id} id={id} />
            ))}
            {!hasVendors && filterNoVendors}
        </Group>
    );
};

export { BannerTcfVendorList };
