import { extendBlockerContentStylesheet } from "@devowl-wp/web-cookie-banner";

import { useBlockerStylesheet } from "../../../hooks/blocker/useBlockerStylesheet.js";
import { useCommonFooterLinks } from "../../../hooks/common/useFooterLinks.js";

import type { FC } from "react";

const BlockerFooter: FC = () => {
    const { FooterContainer } = useBlockerStylesheet().extend(...extendBlockerContentStylesheet);
    const { rows: links, render: renderLinks } = useCommonFooterLinks({
        putPoweredByLinkInRow: 1,
    });

    return (
        <FooterContainer>
            <div>{renderLinks(links)}</div>
        </FooterContainer>
    );
};

export { BlockerFooter };
