import { extendBlockerContentStylesheet, extendCommonContentStylesheet } from "@devowl-wp/web-cookie-banner";

import { useBlocker } from "../../../contexts/blocker.js";
import { useBlockerStylesheet } from "../../../hooks/blocker/useBlockerStylesheet.js";

import type { FC, ReactNode } from "react";

const BlockerHeader: FC<{
    closeIcon?: ReactNode;
}> = ({ closeIcon }) => {
    const { hasCloseIcon, HeaderTitle, HeaderContainer } = useBlockerStylesheet()
        .extend(...extendCommonContentStylesheet)
        .extend(...extendBlockerContentStylesheet);

    const blocker = useBlocker();
    const {
        blocker: { name },
        texts: { blockerHeadline },
        keepVariablesInTexts,
    } = blocker;

    return (
        <HeaderContainer>
            <div>
                <HeaderTitle className={closeIcon ? hasCloseIcon : undefined}>
                    {keepVariablesInTexts ? blockerHeadline : blockerHeadline.replace(/{{name}}/gi, name)}
                </HeaderTitle>
                {closeIcon}
            </div>
        </HeaderContainer>
    );
};

export { BlockerHeader };
