import { FooterLink } from "./link.js";
import { Tooltip } from "../../tooltip.js";

import type { CommonContextProps } from "../../../types/commonContext.js";
import type { FC } from "react";

const FooterPoweredByLink: FC<{
    poweredLink: CommonContextProps["poweredLink"];
    affiliate: CommonContextProps["affiliate"];
}> = ({ poweredLink, affiliate }) => {
    return (
        <FooterLink href={affiliate ? affiliate.link : poweredLink.href} target={poweredLink.target} key="powered-by">
            <span dangerouslySetInnerHTML={{ __html: poweredLink.innerHTML }} />
            {affiliate && (
                <Tooltip title={affiliate.description as string} position="top-left">
                    {" "}
                    {affiliate.labelBehind}
                </Tooltip>
            )}
        </FooterLink>
    );
};

export { FooterPoweredByLink };
