import type { EServiceTemplateGoogleConsentModeTypes } from "@devowl-wp/api-real-cookie-banner";
import { extendCommonGroupsStylesheet } from "@devowl-wp/web-cookie-banner";

import { useBannerStylesheet } from "../../../hooks/banner/useBannerStylesheet.js";
import { useBannerOrBlocker } from "../../../hooks/useBannerOrBlocker.js";
import { Checkbox } from "../checkbox.js";

import type { FC } from "react";

const GcmConsentType: FC<{ type: EServiceTemplateGoogleConsentModeTypes; isDisabled?: boolean; isBold?: boolean }> = ({
    type,
    isDisabled,
    isBold,
}) => {
    const { Cookie } = useBannerStylesheet().extend(...extendCommonGroupsStylesheet);
    const {
        activeAction,
        gcmConsent,
        updateGcmConsentTypeChecked,
        group: { descriptionFontSize },
        i18n: {
            gcm: {
                purposes: { [type]: purposeText },
            },
        },
    } = useBannerOrBlocker();

    return (
        <Cookie>
            <Checkbox
                isChecked={gcmConsent.indexOf(type) > -1}
                isDisabled={isDisabled || activeAction === "history"}
                fontSize={descriptionFontSize}
                onToggle={(state) => updateGcmConsentTypeChecked(type, state)}
            >
                <span style={{ fontWeight: isBold ? "bold" : undefined }}>{purposeText}</span>
            </Checkbox>
        </Cookie>
    );
};

export { GcmConsentType };
