import { MinusOutlined } from "@ant-design/icons-svg";

import { findUsedGcmConsentTypes } from "@devowl-wp/cookie-consent-web-client";

import { useBannerOrBlocker } from "../../../hooks/useBannerOrBlocker.js";
import { AccordionItem, AccordionList } from "../accordionItem.js";

import type { VisualService } from "../../../types/service.js";
import type { FC } from "react";

const GcmConsentTypesList: FC<{ services: VisualService[] }> = ({ services }) => {
    const usedPurposes = findUsedGcmConsentTypes(services);
    const {
        i18n: {
            gcm: { purposes: i18nPurposes },
        },
    } = useBannerOrBlocker();

    return (
        <AccordionList>
            {usedPurposes.map((purpose) => (
                <AccordionItem key={purpose} title={i18nPurposes[purpose]} icon={MinusOutlined} expandable={false} />
            ))}
        </AccordionList>
    );
};

export { GcmConsentTypesList };
