import { extendCommonGroupsStylesheet } from "@devowl-wp/web-cookie-banner";

import { CookiePropertyList } from "./cookiePropertyList.js";
import { useStylesheet } from "../../../contexts/stylesheet.js";
import { useA11yId } from "../../../hooks/useA11yId.js";
import { useBannerOrBlocker } from "../../../hooks/useBannerOrBlocker.js";
import { Checkbox } from "../checkbox.js";

import type { VisualService } from "../../../types/service.js";
import type { ComponentProps, FC } from "react";

const Cookie: FC<{
    cookie: VisualService;
    checked?: boolean;
    disabled?: boolean;
    onToggle?: ComponentProps<typeof Checkbox>["onToggle"];
    propertyListProps?: Omit<ComponentProps<typeof CookiePropertyList>, "children" | "cookie">;
}> = ({ cookie, checked, disabled, onToggle, propertyListProps = {} }) => {
    const { Cookie } = useStylesheet().extend(...extendCommonGroupsStylesheet);
    const { name } = cookie;
    const {
        group: { descriptionFontSize },
    } = useBannerOrBlocker();
    const a11yCheckboxDescription = useA11yId();

    return (
        <Cookie>
            <Checkbox
                isChecked={checked}
                isDisabled={disabled}
                fontSize={descriptionFontSize}
                onToggle={onToggle}
                aria-describedby={a11yCheckboxDescription}
            >
                <strong>{name}</strong>
            </Checkbox>
            <div id={a11yCheckboxDescription}>
                <CookiePropertyList cookie={cookie} {...propertyListProps} isDisabled={!checked} />
            </div>
        </Cookie>
    );
};

export { Cookie };
