import { renderIconDefinitionToSVGElement } from "@ant-design/icons-svg/es/helpers";
import { useMemo } from "react";

import type { DetailedHTMLProps, FC, HTMLAttributes } from "react";

/**
 * Inject a plain SVG icon from `@ant-design/icons-svg`. This reduces the bundle size.
 * You can determine yourself to use `@ant-design/icons` or this helper component. For example,
 * this component is preferred for website bundles where website size matters.
 *
 * @see https://app.clickup.com/t/60pz5t
 */
const PlainAntdIconAsSvg: FC<
    {
        icon: Parameters<typeof renderIconDefinitionToSVGElement>[0];
    } & DetailedHTMLProps<HTMLAttributes<HTMLDivElement>, HTMLDivElement>
> = ({ icon, ...rest }) => {
    const svgString = useMemo(
        () =>
            renderIconDefinitionToSVGElement(icon, {
                extraSVGAttrs: { style: "width:auto;height:100%;", fill: "currentColor" },
            }),
        [icon],
    );

    return <div {...rest} dangerouslySetInnerHTML={{ __html: svgString }} />;
};

export { PlainAntdIconAsSvg };
