import { forwardRef } from "react";

import { hintCss } from "@devowl-wp/web-cookie-banner";

import type { HTMLAttributes } from "react";

/**
 * This is a very basic `hint.css` implementation for a tooltip.
 *
 * @see https://kushagra.dev/lab/hint/
 */
const Tooltip = forwardRef<
    HTMLDivElement,
    Parameters<typeof hintCss>[0] & Omit<HTMLAttributes<HTMLDivElement>, "title">
>(({ children, title, position, color, size, always, rounded, noAnimate, bounce, className, ...rest }, ref) => {
    return (
        <div
            ref={ref}
            {...rest}
            {...hintCss({ title, always, position, color, size, rounded, noAnimate, bounce, className })}
        >
            {children}
        </div>
    );
});

export { Tooltip };
