import type { EServiceTemplateGoogleConsentModeTypes } from "@devowl-wp/api-real-cookie-banner";
import type { BlockerMountPaintMode } from "@devowl-wp/headless-content-unblocker";
import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";
import type { Customize } from "@devowl-wp/web-cookie-banner";

import type { VisualBlocker } from "../types/blocker.js";
import type { CommonContextProps } from "../types/commonContext.js";
import type { MouseEvent } from "react";

const BLOCKER_CONTEXT_SYMBOL = Symbol();
type BlockerContext = ImmutableContext<{
    initialState: Customize &
        Omit<
            CommonContextProps,
            // Currently only needed for TCF and TCF is not supported in visual content blocker
            "isTcf"
        > & {
            blocker: VisualBlocker;
            container: HTMLElement;
            /**
             * Can be `undefined` if there is no blocked element associated to this content blocker.
             */
            blockedNode?: HTMLElement;
            /**
             * Create the content blocker before this element.
             */
            createBefore?: HTMLElement;
            paintMode?: BlockerMountPaintMode;
        };
    modifiers: Partial<{
        onUnblock: (event?: MouseEvent) => void;
        updateGcmConsentTypeChecked: (type: EServiceTemplateGoogleConsentModeTypes, state: boolean) => void;
    }>;
}>;

const useBlocker: FnCreateImmutableContextForSymbol<BlockerContext> = () =>
    useImmutableContext<BlockerContext>(BLOCKER_CONTEXT_SYMBOL);

const useBlockerProvider: FnCreateImmutableContextProviderForSymbol<BlockerContext> = (...args) =>
    useImmutableContextProvider<BlockerContext>(BLOCKER_CONTEXT_SYMBOL, ...args);

export { type BlockerContext, useBlocker, useBlockerProvider };
