import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type { useMainStylesheetForContext } from "../hooks/useMainStylesheetForContext.js";

const STYLESHEET_CONTEXT_SYMBOL = Symbol();
type StylesheetContext = ImmutableContext<{
    initialState: Partial<ReturnType<typeof useMainStylesheetForContext>>;
}>;

const useStylesheet: FnCreateImmutableContextForSymbol<StylesheetContext> = () =>
    useImmutableContext<StylesheetContext>(STYLESHEET_CONTEXT_SYMBOL);

const useStylesheetProvider: FnCreateImmutableContextProviderForSymbol<StylesheetContext> = (...args) =>
    useImmutableContextProvider<StylesheetContext>(STYLESHEET_CONTEXT_SYMBOL, ...args);

export { type StylesheetContext, useStylesheet, useStylesheetProvider };
