import { extendBlockerBodyStylesheet } from "@devowl-wp/web-cookie-banner";

import { useBlockerStylesheet } from "./useBlockerStylesheet.js";
import { useBlocker } from "../../contexts/blocker.js";
import { CONTEXT_LATEST_DESIGN_VERSION } from "../../types/commonContext.js";

const useBlockerClassName = (stylesheet?: Parameters<typeof useBlockerStylesheet>[0]) => {
    const { individualBlockerClassName, showFooter: showFooterClassName } = useBlockerStylesheet(stylesheet).extend(
        ...extendBlockerBodyStylesheet,
    );
    const { designVersion = CONTEXT_LATEST_DESIGN_VERSION } = useBlocker();

    const showFooter = designVersion === 1;
    return [showFooter ? showFooterClassName : undefined, stylesheet.className, individualBlockerClassName]
        .filter(Boolean)
        .join(" ");
};

export { useBlockerClassName };
