import { extendBlockerStylesheet, extendIndividualBlockerStylesheet } from "@devowl-wp/web-cookie-banner";

import { useBlocker } from "../../contexts/blocker.js";
import { useStylesheet } from "../../contexts/stylesheet.js";

import type { StylesheetContext } from "../../contexts/stylesheet.js";

/**
 * Create a stylesheet extension for each rendered visual content blocker, and one stylesheet common
 * for all visual content blockers.
 */
function useBlockerStylesheet(stylesheet?: StylesheetContext["initialState"]) {
    const { blocker } = useBlocker();
    const thisStylesheet = stylesheet || useStylesheet();
    return thisStylesheet
        .extend(...extendIndividualBlockerStylesheet(thisStylesheet.reactRootSymbol, blocker), true)
        .extend(...extendBlockerStylesheet);
}

export { useBlockerStylesheet };
