import { useCallback } from "react";

import type { ServiceTechnicalDefinition } from "@devowl-wp/cookie-consent-web-client";

import { generatePluralText } from "./useTeachings.js";
import { useBannerOrBlocker } from "../useBannerOrBlocker.js";

function useDurationText() {
    const {
        i18n: { durationUnit: durationUnitTexts, unknown },
    } = useBannerOrBlocker();

    return useCallback(
        (duration: number, unit: ServiceTechnicalDefinition["durationUnit"]) =>
            typeof duration === "number"
                ? generatePluralText(duration, durationUnitTexts["n1"][unit], durationUnitTexts["nx"][unit])
                : unknown,
        [durationUnitTexts, unknown],
    );
}

export { useDurationText };
