import { useBannerOrBlocker } from "../useBannerOrBlocker.js";

import type { VisualService } from "../../types/service.js";

function useGroupItems<T = VisualService>(
    map?: (value: VisualService, index: number, array: VisualService[]) => T,
): T[] {
    const { groups } = useBannerOrBlocker();
    let result = groups.map(({ items }) => [...items]).flat() as any[];

    if (map) {
        result = result.map(map).filter(Boolean);
    }

    return result;
}

export { useGroupItems };
