import type { BannerContext } from "../../contexts/banner.js";
import type { BlockerContext } from "../../contexts/blocker.js";

function useStateContextCallbacks<T extends BannerContext | BlockerContext>(): Pick<
    T["provider"]["modifiers"],
    "updateGcmConsentTypeChecked"
> {
    return {
        updateGcmConsentTypeChecked: (({ gcmConsent }, type, checked) => {
            /* onlypro:start */
            if (process.env.PLUGIN_CTX === "pro") {
                const indexOf = gcmConsent.indexOf(type);
                if (checked && indexOf === -1) {
                    gcmConsent.push(type);
                } else if (!checked && indexOf > -1) {
                    gcmConsent.splice(indexOf, 1);
                }
            }
            /* onlypro:end */
        }) as BannerContext["provider"]["modifiers"]["updateGcmConsentTypeChecked"],
    };
}

export { useStateContextCallbacks };
