import { useMemo } from "react";

import { useStylesheet } from "../contexts/stylesheet.js";

import type { StylesheetContext } from "../contexts/stylesheet.js";

function useA11yId(stylsheet?: StylesheetContext["initialState"]) {
    const {
        functions: { className },
    } = stylsheet || useStylesheet();
    return useMemo(() => className(), []);
}

export { useA11yId };
