import { useBanner } from "../contexts/banner.js";
import { useBlocker } from "../contexts/blocker.js";

import type { BannerContext } from "../contexts/banner.js";
import type { BlockerContext } from "../contexts/blocker.js";

/**
 * Use one of the available banner or blocker contexts as union typed.
 */
function useBannerOrBlocker() {
    const banner = useBanner();
    const blocker = useBlocker();

    // Check for a common context property in an available context as it is never `undefined`
    return (banner.groups ? banner : blocker) as BannerContext["contextValue"] & BlockerContext["contextValue"];
}

export { useBannerOrBlocker };
