import { useBannerOrBlocker } from "./useBannerOrBlocker.js";

function useLegalLinks(): Record<
    "privacyPolicy" | "legalNotice",
    | {
          url: string;
          label: string;
      }
    | false
> & { contactForm: string | undefined } {
    const { links = [], websiteOperator } = useBannerOrBlocker();
    const validLinks = links.filter(({ label, url }) => label && url);
    const privacyPolicy = validLinks.find(({ pageType }) => pageType === "privacyPolicy");
    const legalNotice = validLinks.find(({ pageType }) => pageType === "legalNotice");

    return {
        privacyPolicy: privacyPolicy ? { url: privacyPolicy.url, label: privacyPolicy.label } : false,
        legalNotice: legalNotice ? { url: legalNotice.url, label: legalNotice.label } : false,
        contactForm: websiteOperator?.contactFormUrl || undefined,
    };
}

export { useLegalLinks };
