import type { IServiceTemplateClientResponse } from "@devowl-wp/api-real-cookie-banner";
import type { Service, ServiceGroup, ServiceTechnicalDefinition } from "@devowl-wp/cookie-consent-web-client";

type VisualServiceGroup = Omit<ServiceGroup, "items"> & {
    name: string;
    description: string;
    items: VisualService[];
};

type VisualServiceTechnicalDefinition = ServiceTechnicalDefinition & {
    purpose?: string;
};

type VisualService = Omit<Service, "technicalDefinitions"> &
    Pick<
        IServiceTemplateClientResponse,
        | "name"
        | "purpose"
        | "isProviderCurrentWebsite"
        | "provider"
        | "providerContact"
        | "providerLegalNoticeUrl"
        | "providerPrivacyPolicyUrl"
        | "dataProcessingInCountriesSpecialTreatments"
    > & {
        technicalDefinitions: VisualServiceTechnicalDefinition[];
        dataProcessingInCountries: string[];
    };

export { type VisualServiceGroup, type VisualServiceTechnicalDefinition, type VisualService };
