# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 0.1.24 (2026-01-23)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 0.1.23 (2026-01-20)


### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Maintenance

* upgrade dependencies (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.16</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>





## 0.1.22 (2025-11-21)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 0.1.21 (2025-10-15)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 0.1.20 (2025-09-24)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 0.1.19 (2025-09-04)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





## 0.1.18 (2025-07-29)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 0.1.17 (2025-07-10)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>





## 0.1.16 (2025-06-25)


### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.9</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>





## 0.1.15 (2025-05-15)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 0.1.14 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 0.1.13 (2025-05-06)


### Bug Fixes

* touch devices are not working correctly (CU-8698ujw8f)







## 0.1.12 (2025-04-25)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 0.1.11 (2025-04-08)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 0.1.10 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 0.1.9 (2025-03-04)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.3</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>





## 0.1.8 (2025-02-25)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 0.1.7 (2025-02-06)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 0.1.6 (2025-01-14)


### Build System

* locally host iconfonts instead of using alicdn (CU-86979mp3p)







## 0.1.5 (2024-11-07)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.0</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>





## 0.1.4 (2024-10-23)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>





## 0.1.3 (2024-09-26)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>





## 0.1.2 (2024-08-28)

**Note:** This package (@devowl-wp/react-folder-tree) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* performance tuning and shouldUpdate tweaks (CU-861n9jg7k)</details>





## 0.1.1 (2024-08-01)


### Code Refactoring

* move react-aiot to @devowl-wp/react-folder-tree within monorepo (CU-awv3bv)
* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.6</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>





## 0.13.13 (2024-07-16)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.24</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* suppress logs from requests from nullers (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* allow usesNonCookieAccess property in TCF vendor device disclosure (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.10</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.8</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)</details>





## 0.13.12 (2024-06-20)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


### Performance Improvements

* cookie edit form loads faster now when changing fields (CU-8694pd20a)
* cookie edit form loads faster now when changing fields (CU-8694pd20a)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.23</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.5</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.12</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.9</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.11</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.5.3</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.7</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)
* show correct text in second view (CU-8694vgm6z)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.29</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.33</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.5.8</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* **deps :** update dependency mpratt/embera to v2.0.40
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.4</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.3.2</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.13.11 (2024-05-29)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.10</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)
* do not render visual content blockers in nested confirm() blockers (CU-m15mty)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.6</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility elements use prohibited aria attributes aria-labelledby (CU-8694k3zua)
* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)</details>





## 0.13.10 (2024-05-10)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* sticky legal link icon is not aligned correctly when bootstrap is in use (CU-8694dcmep)</details>





## 0.13.9 (2024-04-25)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.21</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introducing password login in rcb (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added moe supported languages (CU-86936my3v)
* disabled default lang edit, hide fields depending on translatable and extended merge strategy plus other fixes (CU-86936my3v)
* enabled statistics with allowedLanguages for translators, changed media permissions (CU-86936my3v)
* filter language select by role parameters (CU-86936my3v)
* introduce lastEditedBy field for templates (CU-86936my3v)
* introduce role parameters to users (CU-86936my3v)
* introducing form field wrapper with role based functionalities and used it for template forms (CU-86936my3v)
* introducing password login in rcb (CU-86936my3v)
* purpose translation variable validation and last editors (CU-86936my3v)
* rename route to user/password (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)
* move password route (CU-86936my3v)</details>





## 0.13.8 (2024-04-23)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.9</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* write NulledVersionUsage deferred (CU-8694939q9)</details>





## 0.13.7 (2024-04-19)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)</details>





## 0.13.6 (2024-04-09)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.5</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* cookie banner not shown in older Safari versions (Hotfix, CU-86947y4pv)</details>





## 0.13.5 (2024-04-09)


### Bug Fixes

* introduce a fallback system when the remote server is not available (CU-1xpcvre)
* reset all template fields in edit form


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.9</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* window.onload assignment should behave like window load event (CU-86947my22)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)


##### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)</details>





## 0.13.4 (2024-03-22)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.3</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.11.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.5.3</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* avoid race conditions when contacting our backend servers to avoid triggering rate limit notice (CU-86939q6ce)</details>





## 0.13.3 (2024-03-13)


### Bug Fixes

* allow also to ignore/unignore service templates in scanner results (CU-31mh4np)


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.8</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to avoid visual content blocker deduplication through custom class rcb-avoid-deduplication on parent element (CU-86940a5nt)
* compatibility with GoodLayers page builder and unblocking background videos (CU-8693wxcad)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.11.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* show service group with partial icon when a service with opt-out is configure (CU-86941b3h8)


##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.5.2</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* allow also to ignore/unignore service templates in scanner results (CU-31mh4np)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.5.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)


##### Styling

* break all links when viewport gets too small on mobile in second view of cookie banner</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.3.0</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)</details>





## 0.13.2 (2024-02-28)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.10.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* when changing consent and WordPress is too slow no changes are saved (CU-8693n1cc5)</details>





## 0.13.1 (2024-02-26)


### Bug Fixes

* errors were no longer shown in service edit form for technical definitions (CU-8693wmp4k)
* show a notice when activating GCM consent mode with Tag Manager integration when previsouly events were active (CU-8693wp05t)


### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.2</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* cookie banner cannot be accepted on old Safari browsers (CU-8693u1wzm)


##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* render shortcodes async and add lazy-require() webpack plugin (CU-8693cqz75)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* empty template name on release warning message (CU-8693uepwd)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.7</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Kadence video popups (CU-8693jtbzu)
* initiators for load event should wait also for async scripts (CU-8693wju7t)


##### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.10.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.4.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Styling

* reset anchor / link styles in cookie banner correctly when theme overwrites it (CU-8693wx9ec)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.2.14</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)</details>





# 0.13.0 (2024-02-05)


### Features

* introduce Google Consent Mode (CU-apv5uu)


### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Features

* introduce Google Consent Mode (CU-apv5uu)


##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.10.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Features

* introduce Google Consent Mode (CU-apv5uu)


##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.5.0</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Features

* introduce Google Consent Mode (CU-apv5uu)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.4.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce Google Consent Mode (CU-apv5uu)


##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>





## 0.12.5 (2024-01-25)


### Bug Fixes

* show a notice for successor templates which replace other templates (CU-869372jf7)
* show rule notice above the rules textare in content blockers if one given (CU-86938uzfp)


### Maintenance

* update to antd@5 (CU-863gku332)
* wordpress part review 4 (CU-869372jf7)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added successorOfIdentifier field to services and content blocker templates (CU-869372jf7)
* extended client response for services and blocker successorOf (CU-869372jf7)
* introduce ruleNotice to content blockers (CU-86938uzfp)
* removed shouldRemoveTechnicalHandlingWhenOneOf (CU-8693g1maw)
* show a notice for successor templates which replace other templates (CU-869372jf7)


##### Features

* introduce Google Consent Mode (CU-8693g1maw)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.6</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Flatsome UX builder and visual content blockers for video embeds (CU-8693jdhgk)


##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.5.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* remove unused duplicated translations of country name (CU-866av8d30)


##### Features

* data processing countries group for Automattic (CU-866av8d30)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.9.10</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.4.4</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* show a notice for successor templates which replace other templates (CU-869372jf7)
* show rule notice above the rules textare in content blockers if one given (CU-86938uzfp)


##### Maintenance

* merge conflict (CU-869372jf7)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.3.9</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.2.13</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* allow updating variables before stylesheet is created (CU-apv5uu)


##### Maintenance

* update to antd@5 (CU-863gku332)</details>





## 0.12.4 (2024-01-18)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 0.12.3 (2024-01-08)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.4</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* awin ad within a link is not correctly unblocked, only on reload (CU-8693ff6kr)</details>





## 0.12.2 (2024-01-04)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Fix

* Admin-UI - Add import/export functionality (CU-86934facb)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.8.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* transform also anchor links with GDPR TCF URL parameters (CU-8693cyetg)</details>





## 0.12.1 (2023-12-22)


### Bug Fixes

* do not output ad networks for vendor configurations with deleted vendors as this leads to TypeError (CU-866aw8zqu)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* several bugs in release view, introduce release status as calculated field for release view (CU-86936mue3)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.3</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* adsbygoogle.push() error: Fluid responsive ads must be at least 250px wide (CU-8693cxm1p)</details>





# 0.12.0 (2023-12-21)


### Features

* improved compatibility with latest Google Adsense requirements and TCF requirements (CU-866aw8zqu)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.9.5</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* list of consents with visual content blockers did no longer work (CU-86939w8af)


##### Performance

* do not encode TCModel when initial cookie banner is loaded (CU-8693cf1zr)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.4.0</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Features

* improved compatibility with latest Google Adsense requirements and TCF requirements (CU-866aw8zqu)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>





## 0.11.1 (2023-12-19)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





# 0.11.0 (2023-12-15)


### Bug Fixes

* show creation date of templates instead of version number in Differing from template popup (CU-86936mue3)


### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added delete button to media images (CU-8692wfhgk)
* added possibility for release dependency checks WIP (CU-86932dder)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.8.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* when TCF is active, it sometimes requests new consent every day (CU-86939gwcj)


##### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.9.3</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* animation out did no longer work for cookie banner in some cases (CU-869383vck)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.3.7</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* show creation date of templates instead of version number in Differing from template popup (CU-86936mue3)</details>





## 0.10.2 (2023-11-28)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.2</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* allow to show cookie banner also on wp-login.php page when body has class force-cookie-banner (CU-869379120)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>





## 0.10.1 (2023-11-24)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* uncaught exception in frontend when using PixelYourSite template (CU-86936r76h)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.9.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* customizer did not load in some cases (CU-86936qctz)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.3.5</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* manager Google Tag Manager can be created through scanner even marked as Disabled (CU-86936qzwq)</details>





# 0.10.0 (2023-11-22)


### Bug Fixes

* 404 error when navigating too fast from cookies tab (CU-86935hjf1)
* allow to reset fields for templates even without update (CU-86930f9du)


### Features

* allow to create multiple TCF vendors in batch by using table checkboxes (CU-86930ub71)
* compose GVL v3 and purposes v3 for TCF 2.2 (CU-863gt04va)
* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)


### Refactoring

* move TCF vendor creation form and list view to @devowl-wp/react-cookie-banner-admin (CU-86930ub71)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Documentation

* added description to distinct langs (CU-86934ynxa)


##### Features

* compose GVL v3 and purposes v3 for TCF 2.2 (CU-863gt04va)
* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* when requesting new consent the cookie banner was visible on privacy policy page (CU-869357t9d)


##### Features

* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.9.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility score in PageSpeed Insights for the language switcher in cookie banner (CU-86935zy2c)


##### Features

* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)


##### Performance

* wait for all suspended components to be mounted and then show cookie banner to avoid CLS (CU-8693572fn)</details>





## 0.9.4 (2023-11-16)


### Maintenance

* fix non-ASCII characters in POT msg strings (CU-86932nwn8)


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.8.3</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* use data-nosnippet to avoid banner texts in SEO snippets (CU-86934vczd)</details>





## 0.9.3 (2023-11-07)


### Bug Fixes

* reload checklist when privacy policy text suggestion were updated (CU-86932cagc)
* typo (CU-2gfb42y)


### Maintenance

* add legal-text to some texts (CU-2gfb42y)
* replace GDPR link to gdpr-info.eu with gdpr-text.com as source (CU-2gfb42y)


<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.3.3</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Bug Fixes

* typo (CU-2gfb42y)</details>





## 0.9.2 (2023-11-02)


### Bug Fixes

* privacy policy text is not copyable when content is empty in case of page builder usage (e.g. Oxygen, CU-86930u18a)


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.8.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* in some cases the button links are not sticky to the bottom in cookie banner (CU-86931j3bm)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.2.7</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* in some cases the button links are not sticky to the bottom in cookie banner (CU-86931j3bm)</details>





## 0.9.1 (2023-10-27)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.13</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Documentation

* update JSDoc, make some methods private and extend some typings (CU-866avtm7z)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.11.5</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added dataProcessingInCountriesSpecialTreatments as extendable attribute (CU-8692z4h5f)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.6.2</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* the Google Tag Manager (GTM) receives opt-ins in Data Layer too late (CU-8692xt11g)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.8.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* open cookie banner when initial URL contains #consent-change (CU-8692zqve3)


##### Performance

* use dedicated <Suspense component for each lazy loaded component (CU-86930ajxx)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.3.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* font color on hover does not get changed for buttons in cookie banner (CU-869305hpq)</details>





# 0.9.0 (2023-10-12)


### Bug Fixes

* inconsistent wording in service overview (CU-866aybqhm)
* isDemoEnv was not used correctly (CU-31976ru)
* when a service is configured essential show the unsafe-countries notice depending on calculated unsafe countries (CU-866aybq9e)


### Features

* introduce age notice age limit (CU-866awy2fr)


### Maintenance

* introduce new developer action RCB/Templates/TechnicalHandlingIntegration (CU-1raqwk8)
* major update react-router-dom (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.11.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Features

* obtaining telemetry data consent after license activation (CU-861n7amqx)


##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.6.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.7.4</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* do not deduplicate content blocker for confirm selector syntax function (CU-866axjayz)


##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.4.5</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.8.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* do not replace minAge and legalBasis variables in cookie banner texts so they work with TranslatePress editor (CU-866awy2fr)


##### Features

* introduce age notice age limit (CU-866awy2fr)


##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.19</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.23</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/service-cloud-consumer 0.3.1</summary>


**_Purpose of dependency:_** _Consume service and blocker templates from service cloud_
##### Maintenance

* introduce new developer action RCB/Templates/TechnicalHandlingIntegration (CU-1raqwk8)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* major update webpack components (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.3.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* prepare upgrade wizard for v4 release (CU-861n7amqx)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.2.5</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>





# 0.8.0 (2023-09-29)


### chore

* add notice text about special treatments when DSG is active (CU-863h7nj72)
* review 1 (CU-863h7nj72)
* review 1 (CU-866axum8u)
* review 1 (CU-cawgkp)
* review 2 (CU-863h7nj72)
* review 2 (CU-cawgkp)
* review 3 (CU-863h7nj72)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)


### feat

* allow to show translations for list views with flags (CU-866aw15cc)
* introduce provider contact fields (phone, email, contact form) for services (CU-863h7nj72)
* make links to legal documents more dynamic (CU-cawgkp)


### fix

* add new Is provider current website option for services (CU-863h7nj72)
* template update with technical definitons with duplicate keys did not work as expected (CU-861n7ak3a)


### refactor

* move settings form to @devowl-wp/react-cookie-banner-admin (CU-863h7nj72)
* rename legalBasis which is applied to the whole cookie banner to territorialLegalBasis (CU-863h7nj72)


### style

* introduce new CSS class which allows antd Select within Input.Group and a Input with addonBefore (CU-863h7nj72)





## 0.7.8 (2023-09-22)


### fix

* typo (CU-861n7ak3a)
* updating templates did not work for some templates (CU-861n7ak3a)





## 0.7.7 (2023-09-21)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.7.6 (2023-09-07)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.7.5 (2023-09-06)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.7.4 (2023-08-30)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.7.3 (2023-08-28)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.7.2 (2023-08-24)


### fix

* allow multiline text for provider field in service (CU-861myq3qm)
* allow multiline text for provider field in service (CU-861myq3qm)


### refactor

* introduce class names and a scoped stylesheet to Cookie Banner instead of style attribute (CU-2yt81xz)





## 0.7.1 (2023-08-02)


### chore

* add niklas to cookie experts faces


### fix

* scrolling to a field in service creation form fails sometimes (e.g. Group, CU-861n1b13e)





# 0.7.0 (2023-07-18)


### chore

* fixed variable typos (CU-863h6pdwd)
* text adjustments for special treatment for unsafe countries (CU-863h6pdwd)


### feat

* minimal translations for special treatments for processing data in unsafe countries (CU-863h6pdwd)


### fix

* introduce special treatments for processing data in unsafe countries (CU-863h6pdwd)
* show legal basis notice from service-cloud templates (CU-863h5d54q)
* show only a limited amount of countries in service form (CU-861n2g4ag)





# 0.6.0 (2023-07-06)


### feat

* new feature to collect consent for services processing data in unsecure countries (CU-861m47jgm)


### fix

* difference from template for service group is empty (CU-32wu2g8)
* introduce pagination to technical cookie information as many items could slow down the form (CU-32wu2g8)
* show notice when service is processing data in unsafe countries and the banner notice is disabled (CU-861m47jgm)
* show provider notice if given (CU-863gx7zt0)


### refactor

* moved technical switches to technical section (CU-32wu2g8)
* rename diff dialog headline to "Default value" (CU-32wu2g8)


### style

* use h2 instead of h1 as it is semantically more correct (CU-863h51na5)





## 0.5.1 (2023-05-30)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.5.0 (2023-05-30)


### chore

* remove old PHP template/preset system as replaced by cloud templates (CU-861me62d8)
* resolve conflict (CU-3207gvx)


### feat

* prepare versions for templates so we can visualize the difference between them (CU-861me62d8)


### refactor

* connect new template center with scanner (WIP, CU-861me62d8)
* connect new template center with service and blocker form (WIP, CU-861me62d8)





## 0.4.10 (2023-05-22)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.9 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





## 0.4.8 (2023-05-19)


### fix

* rename property name of processing countries (CU-861mrugqu)





## 0.4.7 (2023-05-15)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.6 (2023-05-11)


### chore

* update technical cookie information description (CU-861mc9hc2)





## 0.4.5 (2023-04-28)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.4 (2023-04-24)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.3 (2023-04-19)


### chore

* introduce new UI for template center from service cloud (WIP, CU-861me62d8)
* remove non-ASCII characters from POT files (CU-863gffr77)
* start with new template center (WIP, CU-861me62d8)


### fix

* cookie experts logo not shown as expected (CU-861mnv98c)


### refactor

* extract isPro and i18n functions to own context for reusability (CU-861me62d8)
* introduce taskfile.dev Taskfiles (CU-85zrrymj0)





## 0.4.2 (2023-03-24)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.1 (2023-03-21)


### chore

* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)





# 0.4.0 (2023-03-14)


### feat

* new field for service templates "Legal notice URL for provider" (CU-2wpbbhr)





## 0.3.1 (2023-02-21)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.3.0 (2023-02-15)


### chore

* update disclaimer checkboxes (CU-2x5kb66)
* update US data processing form field description (CU-2x5m1gu)


### feat

* introduce new service field Unique Name so 3rd party plugins can obtain consent via Consent API (CU-2unhn5x)





## 0.2.16 (2023-01-25)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.15 (2023-01-10)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.14 (2023-01-03)


### fix

* provide one more dataLayer variable for GTM/MTM realCookieBannerConsents (CU-861m538z2)





## 0.2.13 (2022-12-22)


### chore

* update all package.json to resolve release conflicts (CU-382p4kb)





## 0.2.12 (2022-12-12)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.11 (2022-12-01)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.10 (2022-11-24)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.9 (2022-11-18)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.8 (2022-11-15)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.7 (2022-11-09)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.6 (2022-10-31)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.5 (2022-10-25)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.4 (2022-10-11)


### chore

* introduce consistent type checking for all TypeScript files (CU-2eap113)
* prepare script management for self-hosted Gitlab migrations (CU-2yt2948)
* put gitlab.com URL into environment variables to prepare for self hosted instance (CU-2yt2948)
* remove unused dependencies (CU-3rmk7b)
* switch from yarn to pnpm (CU-3rmk7b)





## 0.2.3 (2022-09-20)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.2 (2022-09-16)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.1 (2022-09-06)

**Note:** This package (@devowl-wp/react-cookie-banner-admin) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.2.0 (2022-08-29)


### chore

* rebase conflicts (CU-2n41u7h)


### feat

* introduce a more intuitive way updating service templates (CU-d0zyw3)


### refactor

* introduce new admin-UI package to prepare for intuitive service template updates (CU-2d8dedh)
* move blocker list component to @devowl-wp/react-cookie-banner-admin (CU-2d8dedh)
* move components of cookie form to @devowl-wp/react-cookie-banner-admin (CU-2d8dedh)
* move first components of cookie form to  @devowl-wp/react-cookie-banner-admin (CU-2d8dedh)
* move group form component to @devowl-wp/react-cookie-banner-admin (CU-d0zyw3)
* move list component to @devowl-wp/react-cookie-banner-admin (CU-d0zyw3)
