import classNames from "classnames";

import { Tooltip } from "./index.js";

import type { TooltipProps } from "./Tooltip.js";

export interface CreatableProps {
    visible?: boolean;
    type?: string;
    cssClasses?: string;
    isCreatableLinkDisabled?: boolean;
    toolTipTitle?: TooltipProps["title"];
    /**
     * If you want to show a tooltip you need to set a toolTipTitle, too.
     */
    toolTipText?: TooltipProps["content"];
    icon?: any;
    label?: any;
    onClick?: (type: string) => void;
}

/**
 * A creatable button is next to the headline. The use case for
 * a creatable button is for example the "Create folder" button.
 *
 * @returns
 */
export const Creatable = ({
    visible = true,
    type,
    cssClasses,
    isCreatableLinkDisabled,
    toolTipTitle,
    toolTipText,
    icon,
    label,
    onClick,
}: CreatableProps) => {
    if (!visible) return null;

    const className = classNames(cssClasses, {
        "aiot-disabled": isCreatableLinkDisabled,
    });
    const body = (
        <button data-aio-type={type} className={className} onClick={() => onClick && onClick(type)}>
            {icon} {label}
        </button>
    );

    return toolTipTitle ? (
        <Tooltip title={toolTipTitle} content={toolTipText}>
            {body}
        </Tooltip>
    ) : (
        body
    );
};
