import { Creatable, Spin, Toolbar } from "./index.js";

import type { CreatableProps } from "./Creatable.js";
import type { ToolbarProps } from "./Toolbar.js";
import type { ToolbarButtonProps } from "./ToolbarButton.js";

export interface HeaderProps {
    headline?: any;
    creatable: {
        buttons: {
            [s: string]: CreatableProps;
        };
        backButton: CreatableProps;
    };
    isCreatableLinkDisabled?: CreatableProps["isCreatableLinkDisabled"];
    /**
     * If true the props.creatable.backButton is parsed as Creatable button
     */
    isCreatableLinkCancel?: boolean;
    isToolbarActive?: ToolbarProps["isToolbarActive"];
    isToolbarBusy?: ToolbarProps["isToolbarBusy"];
    toolbar: {
        buttons: {
            [s: string]: ToolbarButtonProps;
        };
        backButton: ToolbarProps["backButton"];
    };
    multiToolbar: HeaderProps["toolbar"];
    /**
     * The active toolbar button (must match the same as the object key of the button)
     */
    toolbarActiveButton?: ToolbarProps["activeButton"];
    isBusyHeader?: boolean;
    checkedNodes?: ToolbarProps["checkedNodes"];
    onCloseMultiToolbar?: ToolbarProps["onCloseMultiToolbar"];
}

/**
 * Render the header with headline, buttons and toolbar. In this part the sticky component
 * is ensured and you do not have to worry about it.
 *
 * @param {object} props Properties
 * @param {object<key,object>} [props.toolbar.buttons] The toolbar buttons
 * @param {object} [props.toolbar.backButton] The toolbar back button. Is showed if toolbarActiveButton is set
 *
 * @returns
 */
export const Header = ({
    headline,
    creatable,
    isCreatableLinkDisabled,
    isCreatableLinkCancel,
    isToolbarActive,
    isToolbarBusy,
    toolbar,
    multiToolbar,
    toolbarActiveButton,
    isBusyHeader,
    checkedNodes,
    onCloseMultiToolbar,
}: HeaderProps) => {
    const useToolbar = checkedNodes.length ? multiToolbar : toolbar;

    return (
        // @ts-expect-error outdated @types/react
        <Spin spinning={!!isBusyHeader} size="small">
            <div className="aiot-tree-headline">
                {headline}
                {!isCreatableLinkCancel ? (
                    Object.keys(creatable.buttons).map((key) => (
                        <Creatable
                            key={key}
                            type={key}
                            {...creatable.buttons[key]}
                            isCreatableLinkDisabled={isCreatableLinkDisabled}
                        />
                    ))
                ) : (
                    <Creatable {...creatable.backButton} type="_aio_cancel" />
                )}
            </div>
            {(!!Object.keys(useToolbar.buttons).length || checkedNodes.length > 0) && (
                <Toolbar
                    isToolbarActive={isToolbarActive}
                    isToolbarBusy={isToolbarBusy}
                    buttons={useToolbar.buttons}
                    backButton={useToolbar.backButton}
                    activeButton={toolbarActiveButton}
                    checkedNodes={checkedNodes}
                    onCloseMultiToolbar={onCloseMultiToolbar}
                />
            )}
        </Spin>
    );
};
