import Popover from "antd-legacy/lib/popover";

import "antd-legacy/lib/popover/style/index.css";
import type { TooltipPlacement } from "antd-legacy/lib/tooltip";

export interface TooltipProps {
    placement?: TooltipPlacement;
    children?: any;
    title?: any;
    content?: any;
    mouseEnterDelay?: number;
    mouseLeaveDelay?: number;
    overlayClassName?: any;
}

/**
 * Custom All-In-One Tree tooltip implementation with the help of antd-legacy-design.
 *
 * @param {object} props Properties
 * @param {string} [props.placement='bottom'] The placement
 * @param {Element|string} [props.children] The children which should get the tooltip
 * @param {Element|string} [props.title] The tooltip title
 * @param {Element|string} [props.content] The tooltip content
 * @param {float} [props.mouseEnterDelay=0.2] The mouse enter delay
 * @param {float} [props.mouseLeaveDelay=0] The mouse leave delay
 * @see https://ant.design/components/popover/
 */
export const Tooltip = ({
    placement = "bottom",
    children,
    title,
    content,
    mouseEnterDelay = 0.2,
    mouseLeaveDelay = 0,
    ...rest
}: TooltipProps) => {
    const popoverContent = (
        <div style={{ fontSize: 12, maxWidth: 200 }}>
            <div
                style={{
                    fontWeight: "bold",
                    fontSize: 14,
                    paddingBottom: 5,
                    marginBottom: 3,
                    borderBottom: "1px solid rgba(255,255,255,0.3)",
                }}
            >
                {title}
            </div>
            {content}
        </div>
    );

    return (
        <Popover
            content={popoverContent}
            placement={placement}
            mouseEnterDelay={mouseEnterDelay}
            mouseLeaveDelay={mouseLeaveDelay}
            {...rest}
        >
            {children}
        </Popover>
    );
};
