import { useMemo } from "react";

import { yieldMainThread } from "../utils/yieldMainThread.js";

import type { DependencyList } from "react";

/**
 * Allows to return the result of a `useMemo` as `Promise` which you could use e.g. to
 * render your UI with React's `use` method. Additionally, it yields the main thread by using `setTimeout`.
 *
 * TODO: `AbortController` to cancel the running memoization
 */
function useAsyncMemo<T>(fn: () => Promise<T>, deps: DependencyList) {
    return useMemo(() => yieldMainThread().then(fn), deps);
}

export { useAsyncMemo };
