import { useCallback, useEffect, useRef, useState } from "react";

type Callback = (...args: any[]) => any;

function useRunCallbackNextRender() {
    const [increment, setIncrement] = useState({});
    const ref = useRef<Callback[]>([]);

    useEffect(() => {
        let c: Callback;
        while ((c = ref.current.pop())) {
            c();
        }
    }, [increment]);

    return useCallback((callback: Callback) => {
        ref.current.push(callback);
        setIncrement({});
    }, []);
}

export { useRunCallbackNextRender };
