function arrayMove(array: any[], oldIndex: number, newIndex: number) {
    const { length } = array;
    const startIndex = oldIndex < 0 ? length + oldIndex : oldIndex;

    if (startIndex >= 0 && startIndex < length) {
        const endIndex = newIndex < 0 ? length + newIndex : newIndex;
        const [item] = array.splice(oldIndex, 1);
        array.splice(endIndex, 0, item);
    }
}

export { arrayMove };
