/**
 * Unicode-safe base64 encoding.
 *
 * @see https://stackoverflow.com/a/30106551/5506547
 */
function base64EncodeUnicodeSafe(str: string) {
    return btoa(
        encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, (match, p1) => String.fromCharCode(parseInt(p1, 16))),
    );
}

export { base64EncodeUnicodeSafe };
