/**
 * Truncate a string with separator in the middle of the string.
 *
 * @see https://stackoverflow.com/a/5723274/5506547
 */
function truncateMiddle(str: string, maxLength = 50, separator = "...") {
    if (!str || str.length <= maxLength) {
        return str;
    }

    const sepLen = separator.length;
    const charsToShow = maxLength - sepLen;
    const frontChars = Math.ceil(charsToShow / 2);
    const backChars = Math.floor(charsToShow / 2);

    return str.substr(0, frontChars) + separator + str.substr(str.length - backChars);
}

export { truncateMiddle };
