import type { ScorePool } from "./iterateRules.js";

function calculateInlineScore(element: HTMLElement, property: keyof CSSStyleDeclaration): ScorePool["items"][0] {
    const inline = element.style[property] as string | number;
    return inline
        ? {
              selector: "! undefined !",
              specificity: 10000 + (new String(inline).match(/\s!important/gi) ? 100000 : 0),
              style: inline,
          }
        : undefined;
}

export { calculateInlineScore };
