import { calculate } from "specificity";

import { priorityByRule } from "./priorityByRule.js";

function calculateScore(rule: CSSStyleRule, stackSize: number, property: keyof CSSStyleDeclaration) {
    const score = +calculate(rule.selectorText)[0].specificity.replace(/,/g, "");
    const specificity = stackSize + score * 10 + priorityByRule(rule, property);
    return {
        selector: rule.selectorText,
        specificity,
    };
}

export { calculateScore };
