import { iterateRules } from "./iterateRules.js";

import type { ScorePool } from "./iterateRules.js";

async function iterateStylesheets(element: HTMLElement, scores: ScorePool, property: keyof CSSStyleDeclaration) {
    const { styleSheets } = document;
    for (const styleSheetIdx in styleSheets) {
        const styleSheet = styleSheets[styleSheetIdx];
        let rules: CSSRuleList;

        try {
            rules = styleSheet.cssRules || styleSheet.rules;
        } catch (e) {
            // Rules could not be read, e.g. CORS policy (https://stackoverflow.com/a/49994161/5506547)
            continue;
        }

        if (!rules) {
            continue;
        }

        await iterateRules(rules, element, scores, property);
    }
}

export { iterateStylesheets };
