import type { CreatePureScopedStylesheetCallbackArgs } from "@devowl-wp/web-scoped-css";

import type { MainStyleSheetReturn } from "../main.js";

const extendTeachingStylesheet = [
    Symbol("extendTeachingStylesheet"),
    (
        { jsx, boolIf, boolOr }: CreatePureScopedStylesheetCallbackArgs,
        { individualLayout, design, bodyDesign, boolLargeOrMobile, layout }: MainStyleSheetReturn,
    ) => {
        const [Teaching, teachingClassName] = jsx("p", {
            classNames: "teaching",
            all: "unset",
            display: "block",
            marginTop: "7px",
            textAlign: boolIf(bodyDesign.teachingsInheritTextAlign, "inherit", bodyDesign.teachingsTextAlign()),
            color: boolIf(bodyDesign.teachingsInheritFontColor, "inherit", bodyDesign.teachingsFontColor()),
            fontSize: boolIf(
                bodyDesign.teachingsInheritFontSize,
                "inherit",
                boolLargeOrMobile(bodyDesign.teachingsFontSize, boolIf),
            ),
        });

        const [DescriptionContainer] = jsx("div", {
            classNames: "description",
            lineHeight: 1.5,
            textAlign: individualLayout.descriptionTextAlign(),
            fontSize: boolIf(
                bodyDesign.descriptionInheritFontSize,
                boolLargeOrMobile(design.fontSize, boolIf),
                boolLargeOrMobile(bodyDesign.descriptionFontSize, boolIf),
            ),
            pseudos: {
                [`> p:not(${teachingClassName})`]: {
                    all: "unset",
                },
                " a:not([aria-expanded])": {
                    all: "unset",
                    cursor: "pointer",
                    color: "inherit",
                    textDecoration: design.linkTextDecoration(),
                },
                " a:not([aria-expanded]):hover": {
                    // Can be overwritten by themes
                    textDecoration: design.linkTextDecoration(),
                },
            },
        });

        const [TeachingSeparator] = jsx(
            "div",
            {
                classNames: "teaching-separator",
                display: boolIf(bodyDesign.teachingsSeparatorActive, "block", "none"),
                pseudos: {
                    ":after": {
                        content: "''",
                        marginTop: "7px",
                        display: "block",
                        maxWidth: bodyDesign.teachingsSeparatorWidth(),
                        borderRadius: layout.borderRadius(),
                        height: bodyDesign.teachingsSeparatorHeight(),
                        background: bodyDesign.teachingsSeparatorColor(),
                        marginLeft: boolIf(
                            boolOr([design.textAlign("is-center"), design.textAlign("is-right")]),
                            "auto",
                        ),
                        marginRight: boolIf(design.textAlign("is-center"), "auto"),
                    },
                },
            },
            {
                "aria-hidden": true,
            },
        );

        return { DescriptionContainer, Teaching, TeachingSeparator };
    },
] as const;

export { extendTeachingStylesheet };
