import { createStylesheet } from "@devowl-wp/web-scoped-css";

const createHintCss = ({
    title,
    position,
    color,
    size,
    always,
    rounded,
    noAnimate,
    bounce,
    className,
}: {
    title: string;
    position?: `${"bottom" | "top"}-${"left" | "right"}` | "bottom" | "left" | "right" | "top";
    color?: "error" | "info" | "warning" | "success";
    size?: "small" | "medium" | "large";
    always?: boolean;
    rounded?: boolean;
    noAnimate?: boolean;
    bounce?: boolean;
    className?: string;
}) => {
    import(/* webpackChunkName: "banner-lazy", webpackMode: "lazy-once" */ "hint.css/hint.min.css?inline-raw").then(
        ({ default: hintCss }) => createStylesheet(hintCss, { id: "hint-css", overwrite: false }),
    );
    return {
        "aria-label": title,
        className: `hint--${position} hint--${size} ${color ? `hint--${color}` : ""} ${always ? `hint--always` : ""} ${
            rounded ? `hint--rounded` : ""
        } ${noAnimate ? `hint--no-animate` : ""} ${bounce ? `hint--bounce` : ""} ${className || ""}`,
    };
};

export { createHintCss as hintCss };
