import type { Properties as CSSProperties } from "csstype";

const SCALING_WHEN_WINDOW_WIDTH_LOWER = 700;

// Sub types
type YesNo = "y" | "n";
type ButtonType = "button" | "link" | "hide";
type ButtonFunctionality = "all" | "essential" | "individual" | "save";
type MarginOrPadding = [number, number, number, number];

type CustomizeLayout = {
    type: "dialog" | "banner";
    maxHeightEnabled: boolean;
    maxHeight: number;
    dialogMaxWidth: number;
    dialogPosition:
        | "topLeft"
        | "topCenter"
        | "topRight"
        | "middleLeft"
        | "middleCenter"
        | "middleRight"
        | "bottomLeft"
        | "bottomCenter"
        | "bottomRight";
    dialogMargin: MarginOrPadding;
    bannerPosition: "top" | "bottom";
    bannerMaxWidth: number;
    overlay: boolean;
    overlayBg: CSSProperties["backgroundColor"];
    overlayBgAlpha: number;
    overlayBlur: number;
    animationIn: string;
    animationInDuration: number;
    animationInOnlyMobile: boolean;
    animationOut: string;
    animationOutDuration: number;
    animationOutOnlyMobile: boolean;
    dialogBorderRadius: number;
    borderRadius: number;
};

type CustomizeDecision = {
    acceptAll: ButtonType;
    acceptEssentials: ButtonType;
    showCloseIcon: boolean;
    acceptIndividual: ButtonType;
    showGroups: boolean;
    groupsFirstView: boolean;
    saveButton: "always" | "afterChange" | "afterChangeAll";
    buttonOrder: string;
};

type CustomizeDesign = {
    bg: CSSProperties["backgroundColor"];
    borderWidth: number;
    borderColor: CSSProperties["borderColor"];
    textAlign: CSSProperties["textAlign"];
    linkTextDecoration: CSSProperties["textDecoration"];
    fontSize: number;
    fontColor: CSSProperties["color"];
    fontInheritFamily: boolean;
    fontFamily: string;
    fontWeight: CSSProperties["fontWeight"];
    boxShadowEnabled: boolean;
    boxShadowOffsetX: number;
    boxShadowOffsetY: number;
    boxShadowBlurRadius: number;
    boxShadowSpreadRadius: number;
    boxShadowColor: CSSProperties["backgroundColor"];
    boxShadowColorAlpha: number;
};

type CustomizeHeaderDesign = {
    inheritBg: boolean;
    bg: CSSProperties["backgroundColor"];
    inheritTextAlign: boolean;
    textAlign: CSSProperties["textAlign"];
    padding: MarginOrPadding;
    logo: string;
    logoRetina: string;
    logoMaxHeight: number;
    logoPosition: "left" | "right" | "above";
    logoMargin: MarginOrPadding;
    logoFitDim?: [number, number];
    logoRetinaFitDim?: [number, number];
    logoAlt: string;
    fontSize: number;
    fontColor: CSSProperties["color"];
    fontInheritFamily: boolean;
    fontFamily: string;
    fontWeight: CSSProperties["fontWeight"];
    borderWidth: number;
    borderColor: CSSProperties["borderColor"];
};

type CustomizeBodyDesign = {
    padding: MarginOrPadding;
    descriptionInheritFontSize: boolean;
    descriptionFontSize: number;
    dottedGroupsInheritFontSize: boolean;
    dottedGroupsFontSize: number;
    dottedGroupsBulletColor: CSSProperties["color"];
    teachingsInheritFontSize: boolean;
    teachingsFontSize: number;
    teachingsInheritFontColor: boolean;
    teachingsFontColor: CSSProperties["color"];
    teachingsInheritTextAlign: boolean;
    teachingsTextAlign: CSSProperties["textAlign"];
    teachingsSeparatorActive: boolean;
    teachingsSeparatorWidth: number;
    teachingsSeparatorHeight: number;
    teachingsSeparatorColor: CSSProperties["backgroundColor"];
    accordionMargin: MarginOrPadding;
    accordionPadding: MarginOrPadding;
    accordionArrowType: "none" | "filled" | "outlined";
    accordionArrowColor: CSSProperties["color"];
    accordionBg: CSSProperties["backgroundColor"];
    accordionActiveBg: CSSProperties["backgroundColor"];
    accordionHoverBg: CSSProperties["backgroundColor"];
    accordionBorderWidth: number;
    accordionBorderColor: CSSProperties["borderColor"];
    accordionTitleFontSize: number;
    accordionTitleFontColor: CSSProperties["color"];
    accordionTitleFontWeight: CSSProperties["fontWeight"];
    accordionDescriptionMargin: MarginOrPadding;
    accordionDescriptionFontSize: number;
    accordionDescriptionFontColor: CSSProperties["color"];
    accordionDescriptionFontWeight: CSSProperties["fontWeight"];
    acceptAllOneRowLayout: boolean;
    acceptAllFontSize: number;
    acceptAllPadding: MarginOrPadding;
    acceptAllBg: CSSProperties["backgroundColor"];
    acceptAllTextAlign: CSSProperties["textAlign"];
    acceptAllBorderWidth: number;
    acceptAllBorderColor: CSSProperties["borderColor"];
    acceptAllFontColor: CSSProperties["color"];
    acceptAllFontWeight: CSSProperties["fontWeight"];
    acceptAllHoverBg: CSSProperties["backgroundColor"];
    acceptAllHoverFontColor: CSSProperties["color"];
    acceptAllHoverBorderColor: CSSProperties["borderColor"];
    acceptEssentialsButtonType: ButtonType;
    acceptEssentialsUseAcceptAll: boolean;
    acceptEssentialsFontSize: number;
    acceptEssentialsFontWeight: CSSProperties["fontWeight"];
    acceptEssentialsPadding: MarginOrPadding;
    acceptEssentialsBg: CSSProperties["backgroundColor"];
    acceptEssentialsTextAlign: CSSProperties["textAlign"];
    acceptEssentialsBorderWidth: number;
    acceptEssentialsBorderColor: CSSProperties["borderColor"];
    acceptEssentialsFontColor: CSSProperties["color"];
    acceptEssentialsHoverBg: CSSProperties["backgroundColor"];
    acceptEssentialsHoverFontColor: CSSProperties["color"];
    acceptEssentialsHoverBorderColor: CSSProperties["borderColor"];
    acceptIndividualFontSize: number;
    acceptIndividualFontWeight: CSSProperties["fontWeight"];
    acceptIndividualPadding: MarginOrPadding;
    acceptIndividualBg: CSSProperties["backgroundColor"];
    acceptIndividualTextAlign: CSSProperties["textAlign"];
    acceptIndividualBorderWidth: number;
    acceptIndividualBorderColor: CSSProperties["borderColor"];
    acceptIndividualFontColor: CSSProperties["color"];
    acceptIndividualHoverBg: CSSProperties["backgroundColor"];
    acceptIndividualHoverFontColor: CSSProperties["color"];
    acceptIndividualHoverBorderColor: CSSProperties["borderColor"];
};

type CustomizeFooterDesign = {
    poweredByLink: boolean;
    inheritBg: boolean;
    bg: CSSProperties["backgroundColor"];
    inheritTextAlign: boolean;
    textAlign: CSSProperties["textAlign"];
    padding: MarginOrPadding;
    fontSize: number;
    fontColor: CSSProperties["color"];
    fontInheritFamily: boolean;
    fontFamily: string;
    fontWeight: CSSProperties["fontWeight"];
    hoverFontColor: CSSProperties["color"];
    borderWidth: number;
    borderColor: CSSProperties["borderColor"];
    languageSwitcher: undefined | "disabled" | "flags" | "no-flags";
};

type CustomizeTexts = {
    headline: string;
    description: string;
    acceptAll: string;
    acceptEssentials: string;
    acceptIndividual: string;
    dataProcessingInUnsafeCountries: string;
    tcfStacksCustomName: string;
    tcfStacksCustomDescription: string;
    ageNoticeBanner: string;
    listServicesNotice: string;
    listServicesLegitimateInterestNotice: string;
    ageNoticeBlocker: string;
    consentForwardingExternalHosts: string;
    poweredBy: number;
    blockerHeadline: string;
    blockerLinkShowMissing: string;
    blockerLoadButton: string;
    blockerAcceptInfo: string;
    stickyChange: string;
    stickyHistory: string;
    stickyRevoke: string;
    stickyRevokeSuccessMessage: string;
};

type CustomizeIndividualLayout = {
    inheritDialogMaxWidth: boolean;
    dialogMaxWidth: number;
    inheritBannerMaxWidth: boolean;
    bannerMaxWidth: number;
    descriptionTextAlign: CSSProperties["textAlign"];
};

type CustomizeGroup = {
    checkboxBg: CSSProperties["backgroundColor"];
    checkboxBorderWidth: number;
    checkboxBorderColor: CSSProperties["borderColor"];
    checkboxActiveColor: CSSProperties["color"];
    checkboxActiveBg: CSSProperties["backgroundColor"];
    checkboxActiveBorderColor: CSSProperties["borderColor"];
    groupInheritBg: boolean;
    groupBg: CSSProperties["backgroundColor"];
    groupBorderRadius: number;
    groupPadding: MarginOrPadding;
    groupSpacing: number;
    groupBorderWidth: number;
    groupBorderColor: CSSProperties["borderColor"];
    headlineFontSize: number;
    headlineFontColor: CSSProperties["color"];
    headlineFontWeight: CSSProperties["fontWeight"];
    descriptionFontSize: number;
    descriptionFontColor: CSSProperties["color"];
    linkColor: CSSProperties["color"];
    linkHoverColor: CSSProperties["color"];
    detailsHideLessRelevant: boolean;
};

type CustomizeSaveButton = {
    useAcceptAll: boolean;
    type: "button" | "link";
    fontSize: number;
    padding: MarginOrPadding;
    bg: CSSProperties["backgroundColor"];
    textAlign: CSSProperties["textAlign"];
    borderWidth: number;
    borderColor: CSSProperties["borderColor"];
    fontColor: CSSProperties["color"];
    fontWeight: CSSProperties["fontWeight"];
    hoverBg: CSSProperties["backgroundColor"];
    hoverFontColor: CSSProperties["color"];
    hoverBorderColor: CSSProperties["borderColor"];
};

type CustomizeIndividualTexts = {
    headline: string;
    description: string;
    save: string;
    showMore: string;
    hideMore: string;
    postamble: string;
};

type CustomizeCustomCss = {
    antiAdBlocker: YesNo;
    css: string;
};

type CustomizeMobile = {
    enabled: boolean;
    maxHeight: number;
    hideHeader: boolean;
    alignment: "top" | "center" | "bottom";
    scalePercent: number;
    scalePercentVertical: number;
};

type CustomizeSticky = {
    enabled: boolean;
    animationsEnabled: boolean;
    alignment: "left" | "center" | "right";
    bubbleBorderRadius: number;
    bubbleMargin: MarginOrPadding;
    bubblePadding: number;
    bubbleBg: CSSProperties["backgroundColor"];
    bubbleBorderWidth: number;
    bubbleBorderColor: CSSProperties["borderColor"];
    icon: "fingerprint" | "incognito" | "padlock" | "custom";
    iconSize: number;
    iconCustom: string;
    iconCustomRetina: string;
    iconColor: CSSProperties["color"];
    boxShadowEnabled: boolean;
    boxShadowOffsetX: number;
    boxShadowOffsetY: number;
    boxShadowBlurRadius: number;
    boxShadowSpreadRadius: number;
    boxShadowColor: CSSProperties["backgroundColor"];
    boxShadowColorAlpha: number;
    bubbleHoverBg: CSSProperties["backgroundColor"];
    bubbleHoverBorderColor: CSSProperties["borderColor"];
    hoverIconColor: CSSProperties["color"];
    hoverIconCustom: string;
    hoverIconCustomRetina: string;
    menuFontSize: number;
    menuBorderRadius: number;
    menuItemSpacing: number;
    menuItemPadding: MarginOrPadding;
};

type CustomizeCookiePolicy = {
    instruction: string;
    headlineToc: string;
    headlineControllerOfWebsite: string;
    headlineDiffToPrivacyPolicy: string;
    headlineCookieTechnology: string;
    headlineLegalBasis: string;
    headlineRightsOfTheVisitor: string;
    headlineManageCookies: string;
    headlineCookieOrigin: string;
    headlineListOfServices: string;
    diffToPrivacyPolicy: string;
    cookieTechnology: string;
    legalBasisGdpr: string;
    legalBasisDsg: string;
    rightsOfTheVisitor: string;
    manageCookies: string;
    cookieOrigin: string;
    additionalContent: string;
};

type Customize = {
    layout: CustomizeLayout;
    decision: CustomizeDecision;
    design: CustomizeDesign;
    headerDesign: CustomizeHeaderDesign;
    bodyDesign: CustomizeBodyDesign;
    footerDesign: CustomizeFooterDesign;
    texts: CustomizeTexts;
    individualLayout: CustomizeIndividualLayout;
    group: CustomizeGroup;
    saveButton: CustomizeSaveButton;
    individualTexts: CustomizeIndividualTexts;
    customCss: CustomizeCustomCss;
    mobile: CustomizeMobile;
    sticky: CustomizeSticky;
};

type CustomizeBlocker = {
    presetId: string;
    visualType: "default" | "wrapped" | "hero";
    visualContentType: "map" | "video-player" | "audio-player" | "feed-text" | "feed-video" | "generic";
    isVisualDarkMode: boolean;
    visualBlur: number;
    visualThumbnail?: {
        width: number;
        height: number;
        hide?: ("title" | "overlay")[];
        /**
         * Defaults to `top`.
         */
        titleType?: "center" | "top";
        forceRatio?: number;
    };
};

export {
    SCALING_WHEN_WINDOW_WIDTH_LOWER,
    type CustomizeLayout,
    type CustomizeDecision,
    type CustomizeDesign,
    type CustomizeHeaderDesign,
    type CustomizeBodyDesign,
    type CustomizeFooterDesign,
    type CustomizeTexts,
    type CustomizeIndividualLayout,
    type CustomizeGroup,
    type CustomizeSaveButton,
    type CustomizeIndividualTexts,
    type CustomizeCustomCss,
    type CustomizeMobile,
    type CustomizeSticky,
    type CustomizeCookiePolicy,
    type Customize,
    type CustomizeBlocker,
    type YesNo,
    type ButtonType,
    type ButtonFunctionality,
    type MarginOrPadding,
};
