import type { PureScopedStyleSheet } from "./createStylesheet.js";

const STYLESHEET_ELEMENT_CREATED_EVENT = "stylesheet-created";

type StylesheetElementCreatedEvent = {
    stylesheet: PureScopedStyleSheet;
};

const STYLESHEET_ELEMENT_TOGGLE_EVENT = "stylesheet-toggle";

type StylesheetElementToggleEvent = {
    stylesheet: PureScopedStyleSheet;
    active: boolean;
};

const UPDATE_EVENT_PREFIX = `css-var-update-`;
// eslint-disable-next-line @typescript-eslint/no-empty-object-type
type UpdateEvent = {
    /*
    Not needed atm
    previous: Value;
    current: Value;
    */
};

export {
    STYLESHEET_ELEMENT_CREATED_EVENT,
    type StylesheetElementCreatedEvent,
    STYLESHEET_ELEMENT_TOGGLE_EVENT,
    type StylesheetElementToggleEvent,
    UPDATE_EVENT_PREFIX,
    type UpdateEvent,
};
