const throttling = (timeout: "raf" | number, callback: (...args: any[]) => any) => {
    if (timeout === "raf") {
        let ticking = false;
        return () => {
            if (!ticking) {
                window.requestAnimationFrame(() => {
                    callback();
                    ticking = false;
                });
                ticking = true;
            }
        };
    } else {
        let t: number;
        return () => {
            clearTimeout(t);
            t = setTimeout(callback, timeout);
        };
    }
};

export { throttling };
