# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.0.41 (2026-02-02)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.6.3</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* avoid passing complete zod schemas to ContractResponse (CU-869bdvdfh)</details>





## 1.0.40 (2026-01-23)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.8</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.36</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.25</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.26</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>





## 1.0.39 (2026-01-20)


### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Maintenance

* upgrade to Node 24 (CU-86931jwau)


<details><summary>Development dependency update @devowl-wp/api 1.6.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* add HTTP 410 Gone status for deleted reports in order service (CU-8699tgz5g)
* add media upload functionality for logos (CU-8699tgz5g)
* adjust Content-Type handling in fetch client to allow browser to set for FormData (CU-8699tgz5g)
* do not hide internal routes in OpenAPI in non-production environments (CU-8699tgz5g)
* improve developer experience as using schema-mutable methods outside the middleware looses validations and refinements (CU-8699tgz5g)
* prevent duplicate tags in OpenAPI document generation (CU-8699tgz5g)
* review points including 20 (CU-8699tgz5g)
* throw runtime error when refine is used in schema definition (CU-8699tgz5g)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* update refine function parameter naming for consistency across schemas (CU-8699tgz5g)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Documentation

* enhance group management by introducing parent relationships and sorting (CU-8699tgz5g)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.20</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.35</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.2</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.13</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* validate vat id syntax for eu and ch (CU-8699tgz5g)


##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.24</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.25</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.16</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.51</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.21</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.18</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>





## 1.0.38 (2026-01-15)


### Bug Fixes

* exclude real_cookie_banner cookies from consent checks notice (CU-869bh0uwq)


### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)


<details><summary>Development dependency update @devowl-wp/api 1.6.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* refactor new Contract API (CU-8699twn1u)


##### Maintenance

* ai review (CU-8699twn1u)
* fix issues found in testing (CU-8699twn1u)
* fix purpose in contracts ((CU-8699twn1u)
* remove package.json#engines from internal packages (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.34</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* consent handling to use a transport object for better flexibility and add support for 'or' condition in consent checks (CU-f535x6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* in some cases content does not get unblocked when scripts without loading-semantics need to be unblocked first (CU-869brj1eb)


##### Code Refactoring

* consent handling to use a transport object for better flexibility and add support for 'or' condition in consent checks (CU-f535x6)


##### Maintenance

* code AI review (note 7026, CU-f535x6)</details>





## 1.0.37 (2025-12-10)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.33</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* introduce new client-side: content blocker rule syntax (CU-f535x6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* introduce new client-side: content blocker rule syntax (CU-f535x6)
* prevent iframe location replacement on Firefox Mobile to avoid App-Intent dialog (CU-869be8n2w)


##### Features

* add support for script modules in content blocker (CU-869be7jn7)
* block dynamically injected scripts and stylesheets until consent (CU-f535x6)</details>





## 1.0.36 (2025-12-04)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.5.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* inital implementation of object-storage package (CU-8697h8axv)
* introduce contract profiles with predefined internal profile to exclude from OpenAPI (CU-8699tgz5g)</details>





## 1.0.35 (2025-12-02)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* implement missing file multipart upload in contracts (CU-869badh12)
* implement missing file multipart upload in contracts fetch-client (CU-869badh12)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.21</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* visual confirm.content blocker is shown a second time on click (CU-869b2p070)


##### Performance Improvements

* fix high LCP when using a lot of visual content blockers with confirm() syntax (CU-869b2p070)


##### Tests

* better code coverage with c8 (node-executed code) and v8 (client-side executed code) (CU-f535x6)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.20</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* privacy policy URL in TCF declarations always linked to about:blank (CU-869b2n4v8)</details>





## 1.0.34 (2025-11-21)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to set a x-tagGroups via route details (CU-8699tgz5g)
* remove redundant delivery ack policy handling (CU-869am6b3b)


##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 1.0.33 (2025-10-15)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to create literal error code responses (CU-8699tgz5g)
* allow to define routes to be a webhook (CU-8699tgz5g)
* enhance vendor management contracts with new API endpoints and schema updates (CU-8699tgz5g)
* make optional recursion schema properties work as expected (CU-8699tgz5g)


##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


##### Documentation

* user session and magic link routes improved (CU-8699tgz5g)


##### Features

* enhance vendor and user management with new API endpoints and schema updates (CU-8699tgz5g)
* introduce a contract-first design for message brokers with delivery-tuning (CU-869am6b3b)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.2</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade to PNPM@10 (CU-8697je0ta)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.18</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility for screen reader users (dialog focus, button order, CU-869813z13)


##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.19</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* accessibility for screen reader users (dialog focus, button order, CU-869813z13)</details>





## 1.0.32 (2025-09-24)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* handle too big device disclosures when using TCF and running into memory issues (CU-8696grpwu)


##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.18</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* handle too big device disclosures when using TCF and running into memory issues (CU-8696grpwu)


##### Maintenance

* error texts for invalid TCF device storage disclosures (CU-8696grpwu)</details>





## 1.0.31 (2025-09-12)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow v1, v2, ... versioning beside semantic versioning for contract (CU-8699tgz5g)
* remove undefined values from URLSearchParams (CU-869ad2n4f)


##### Documentation

* add another example for multiple nested recursion objects (CU-8699tgz5g)
* uncaught Error: Cannot find module 'node:async_hooks'</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* ui improments and fixed relation machine translation status calculation (CU-8699vyf8j)


##### Code Refactoring

* simple reorg structure discussed and implemented (CU-8699vyf8j)


##### Features

* implement untranslatable management to keep brand names and custom phrases (CU-8699vv1ap)</details>





## 1.0.30 (2025-09-04)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* content length is not always respond by server if using e.g. Cloudflare with Transfer-Encoding: chunked (CU-869ac6g7m)</details>





## 1.0.29 (2025-09-04)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)
* run guard schema validations isolated from complete contract schema validation (CU-8699z5dt7)


##### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)


##### Documentation

* add README for contract-first instroductions (CU-8699z5dt7)


##### Features

* introduce type-safe createFetchClient from all contracts (CU-869a8xjjf)


##### Tests

* add Vitest test runner for our contracts and introduce a first draft for a RPC client type generator (CU-869a8xjjf)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.15</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)


##### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)
* migrate from @devowl-wp/api-request to new fetch client and remove @devowl-wp/api-request (CU-869a8xjjf)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.25</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* deprecated tag manager events are not put into dataLayer when using the GTM4WP service (CU-31mpbvp)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.15</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* deprecated tag manager events are not put into dataLayer when using the GTM4WP service (CU-31mpbvp)</details>





## 1.0.28 (2025-08-25)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.2.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make API contracts aware of recursion, parameters to object for refinable schema and switch language contexts correctly (CU-8699z5dt7)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.2.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added sl and hr to supported languages (CU-8699ce5ba)</details>





## 1.0.27 (2025-08-08)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.2.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.2.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)</details>





## 1.0.26 (2025-07-29)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.0.25 (2025-07-23)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.11</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* update texts (CU-863h7m9h2)</details>





## 1.0.24 (2025-07-16)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.1.8</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.12</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)</details>





## 1.0.23 (2025-07-10)


### Bug Fixes

* allow to render only specific sections with the rcb-cookie-policy shortcode with sections parameter (CU-8699pvbvb)
* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)


<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.19</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.20</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)


##### Maintenance

* deprecate Google Tag Manager Event and use Google Consent Mode instead (CU-866ay94xn)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.9</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility issues reported by wpaccessibility.day (CU-869813z13)
* accessibility use aria role button for all buttons in the cookie banner (CU-869813z13)
* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.9</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* deprecate Google Tag Manager Event and use Google Consent Mode instead (CU-866ay94xn)
* show Learn More badge next to legal basis for DSG (Schweiz) (CU-866avtc01)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.15</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* accessibility issues reported by wpaccessibility.day (CU-869813z13)
* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.12</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)</details>





## 1.0.22 (2025-06-25)


### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


<details><summary>Development dependency update @devowl-wp/api 1.1.6</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make contract and entity schemas translatable with i18next (CU-8697uqxnq)


##### Code Refactoring

* introduce contracts for api case study (CU-8697uqxnq)


##### Maintenance

* implement learnings from presentation for API contracts (CU-8697uqxnq)
* started to work on a type-safe client fetch wrapper (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.10</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.9</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.19</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.14</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.6</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.8</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.8</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.9</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.44</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.14</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.11</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>





## 1.0.21 (2025-06-11)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.13</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with lazy loaded Google Maps in Voxel theme (CU-86998q97k)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.7</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* replace links with changed slugs (CU-86973be3f)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.13</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* custom CSS is not applied for some CSS classes when a visual content blocker is active on the same page (CU-8699cetgq)


##### Maintenance

* enlargement of the minimum content blocker dialog width to 550 px (CU-fb74tf)</details>





## 1.0.20 (2025-05-15)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.0.19 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Development dependency update @devowl-wp/api 1.1.4</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.8</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.18</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.16</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.11</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.4</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.5</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.5</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.42</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.11</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.9</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 1.0.18 (2025-05-06)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.15</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.10</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Vimeo embeds in Breakdance builder (CU-8698w84ub)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.4</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* remove data-order and order style attributes from consent buttons (CU-8697fw0r4)


##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.4</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* do not show technical handling notice for services with scanner results for Matomo Plugin (CU-865czwv74)


##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.10</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* remove data-order and order style attributes from consent buttons (CU-8697fw0r4)</details>





## 1.0.17 (2025-04-25)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.0.16 (2025-04-22)


### Performance Improvements

* race condition when downloading TCF GVL on Thursday (CU-8698gn11h)







## 1.0.15 (2025-04-14)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.8</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* a deduplicated visual content blocker for Elementor videos autoplays all videos after unblock (CU-8698pajgj)</details>





## 1.0.14 (2025-04-08)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 1.0.13 (2025-04-02)


### Bug Fixes

* do not request new consent on TCF vendor device disclosure update (CU-8698ggfna)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### FEAT

* Service Cloud - Option to enable/disable deactivating all pre-release clients at release (CU-86980gubq)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.1.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Features

* overwork some texts for Orientierungshilfe der Aufsichtsbehörden 1.2 (CU-86972222q)


##### Performance Improvements

* improve LCP count by avoiding a lot of repaints (CU-8698ejjw0)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.1.0</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Features

* overwork some texts for Orientierungshilfe der Aufsichtsbehörden 1.2 (CU-86972222q)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.6</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance Improvements

* improve LCP count by avoiding a lot of repaints (CU-8698ejjw0)</details>





## 1.0.12 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Development dependency update @devowl-wp/api 1.1.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.10</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.6</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.1</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.11</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.12</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.39</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.6</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.5</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 1.0.11 (2025-03-19)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.2</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.9</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.5</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Elementor widget CSS and cut visual content blocker headline (CU-8698c7t2b)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.10</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.11</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* add new ad-network The Moneytizer (CU-8693fhybx)
* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>





## 1.0.10 (2025-03-10)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* add Microsoft Azure to data processing country groups (CU-8697h1a7m)</details>





## 1.0.9 (2025-03-04)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.1.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* corrected calculation full machine translation and introduce flag ignoreOnMachineTranslation (CU-8692xtha4)
* enhance machine translation with granular translation options (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)


##### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* adding isFullyMachineTranslated to wp client responses (CU-8692xtha4)
* copy only properties on machine translation (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)
* review [#5](https://git.owlinfra.de/devowlio/devowl-wp/issues/5) (CU-2yt6wa5)
* review points from comments (CU-8692xtha4)
* skip known missing glossaries supported by deepl (CU-8692xtha4)


##### Code Refactoring

* introduce field names for template types (CU-8695y66h0)
* reading single service and blocker with translations (CU-8692xtha4)
* rename pre-release client route to plural form (CU-2yt6wa5)


##### Documentation

* add documentation (CU-8692xtha4)


##### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation api WIP (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)
* sync weblate and deepl glossaries for translations (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Bug Fixes

* changed licenses route to use params instead of body data (CU-8695xwj6u)
* license post and patch routes (CU-2yt6wa5)


##### Maintenance

* introduce transactions in controllers (CU-861mfub3j)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.9</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)
* show a notice when a template is machine translated (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.3</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)</details>





## 1.0.8 (2025-02-25)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.0.7 (2025-02-24)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.5</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with presto-player (CU-8697zc5r2)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.2</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with presto-player (CU-8697zc5r2)</details>





## 1.0.6 (2025-02-20)


### Bug Fixes

* cookie policy shows cookies despite option which disables cookies for a service (CU-86980khf9)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* add return parameter to the asyn window.consentApi.consent API method (CU-8694x4tnx)


##### Documentation

* improve API docs for consent-checking functions (CU-8694x4tnx)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* correctly block lazy custom web elements by using window.consentApi.unblock API (CU-8697zc5r2)
* make ratio- a ratio CSS class to set the correct height of a blocked element</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.5</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* in GCM mode show link / teach about business.safety.google/privacy (CU-866avf03w)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.6</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* allow to clear all data processing in countries with one click (CU-8694ezcau)
* only show integration notice for opt-in script if opt-in script is given (CU-8694x4tnx)</details>





## 1.0.5 (2025-02-17)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.







## 1.0.4 (2025-02-06)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Elementors optimized markup experimental feature (CU-8697pxjtc)


##### Features

* introduce new selector syntax function jQueryHijackFn to hijack jQuery functions (CU-8697ptyry)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.1.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* requestLanguage added  to controller | find iso 639 language(CU-86971bxhd)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 1.0.3 (2025-01-14)


### Bug Fixes

* include legitimate interest services when implicit bannerless consent is given (CU-8697cpm6k)
* wp_rcb_consent_given API in PHP returns wrong consentGiven when service does not exist (CU-8694x4tnx)


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.0.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* delegate click to unblocked nodes after all resources are loaded (CU-gt22gk)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.3</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* recommended services should mark the content blocker as recommended, too (CU-u9p1w9)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Styles

* cookie banner language switcher is not responsive (CU-86971prz3)</details>





## 1.0.2 (2024-12-06)


### Bug Fixes

* wp_rcb_consent_give() PHP function also supports unique identifiers now (CU-8694x4tnx)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with ACF Frontend Form for Dynamicooo (CU-8696rw241)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* compatibility with darkroomengineering/lenis (CU-8696vxykv)


##### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.1</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)</details>





## 1.0.1 (2024-11-11)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* cookie banner with close icon could no longer be replied in List of consents (CU-8696k7mj7)</details>





# 1.0.0 (2024-11-07)


### Maintenance

* initial release (CU-869656drt)


### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.


<details><summary>Development dependency update @devowl-wp/api 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.0.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.0.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 1.0.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessible link with alt text for sticky legal links
* automatically split POMO translations into translatable strings when TranslatePress is active (CU-8696an3mp)
* texts of cooie banner are not editable in TranslatePress edit screen (CU-8696em1me)


##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 1.0.0</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* allow to reset texts in Cookies > Settings (CU-8696an3mp)
* initial release (CU-869656drt)


##### Performance Improvements

* convert renderPageSelector to functional component (CU-8696an3mp)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/react-utils 1.0.0</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 1.0.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 1.0.0</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>





## 0.2.4 (2024-10-23)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.7.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* cookie banner separator is always left (CU-8696axtt5)</details>





## 0.2.3 (2024-10-23)


### Bug Fixes

* allow to skip uncompress when cookie policy is not compressed (CU-861mva7bm)


### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


<details><summary>Development dependency update @devowl-wp/api 0.5.27</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.14.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.4.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.17</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.10.3</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* failed to construct 'URL': Invalid URL when using MagnificPopup and WooCommerce Upload Files (CU-8695zwvhy)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.16</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Presto Player not rendering all video embeds (CU-86960tuve)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.14.3</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* update links to standard contractual clauses (CU-86969h83e)
* update texts for CDN cards in scanner (CU-86963c70n)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.7.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* visual hero content blocker is not responsive when using a wide width teaching separator (CU-869627051)</details>





## 0.2.2 (2024-09-27)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 0.7.1</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* name of constents for Bunny.bet and Gcore server locations (CU-8695ybqtp)</details>





## 0.2.1 (2024-09-27)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 0.7.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* server locations of Bunny.net and Gcore (CU-8695ybqtp)</details>





# 0.2.0 (2024-09-26)


### Bug Fixes

* geo-restriction does not accept new services automatically when previous consent was also implicit (CU-8695mj2kd)


### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* banner-less consent (cookie banner without cookie banner, CU-fb1hvk)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)
* introduce DSG with Trans-Atlantic Data Privacy Framework compatibility (CU-866avtc01)
* new field for services to change the technical handling execute priority (CU-8695emete)
* show an explanation when using a CDN in the scanner (CU-118mngr)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.14.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* review points 1-10 without 7 (CU-118mngr)
* review points 4 (CU-118mngr)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* added cdn handling to service templates (CU-118mngr)
* introduce execute priority for services (CU-118mngr)
* new field for services to change the technical handling execute priority (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.4.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Features

* banner-less consent (cookie banner without cookie banner, CU-fb1hvk)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.10.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with magnificPopup and YouTube urls covered also by TCF (CU-8695hkk9h)
* unload event listeners are deprecated and will be removed (CU-8695mhu71)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* new field for services to change the technical handling execute priority (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.15</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Divi video slider and visual content blockers (CU-8695kgg74)
* do not stop execution when a hijacked jQuery function runs into an error (CU-8695hkk9h)


##### Performance Improvements

* force to render visual content blockers for :confirm() dialogs in idle step (CU-8695xjmf6)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.6.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* data processing countries group Akamai (CU-betuuk)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.13.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility allow to use escape listener in change/history cookie banner dialog for X-replacement (CU-8695xk0gy)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)
* introduce DSG with Trans-Atlantic Data Privacy Framework compatibility (CU-866avtc01)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.14.0</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* spelling of paragraphs in English (CU-869566d55)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* banner-less consent (cookie banner without cookie banner, CU-fb1hvk)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)
* introduce DSG with Trans-Atlantic Data Privacy Framework compatibility (CU-866avtc01)
* new field for services to change the technical handling execute priority (CU-8695emete)
* show an explanation when using a CDN in the scanner (CU-118mngr)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.7.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)</details>





## 0.1.21 (2024-08-28)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.25</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* apply new eslint rules (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)


##### Code Refactoring

* reordering vars (CU-861n9jg7k)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* fixed es-lint and typings (CU-861n9jg7k)
* hide fields for translator role when empty in default lang (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)
* review 14, hide specific provider fields for translators (CU-861n9jg7k)
* review 3+5, text renames, and display name calculation (CU-861n9jg7k)


##### Code Refactoring

* reordering vars (CU-861n9jg7k)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 0.1.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* performance tuning and shouldUpdate tweaks (CU-861n9jg7k)</details>





## 0.1.20 (2024-08-13)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.6</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Styles

* do not show a box shadow for banners in mobile view (CU-86955xtbe)</details>





## 0.1.19 (2024-08-08)


### Code Refactoring

* use private fields for Transaction / PersistedTransaction class (CU-8695a0rv7)


<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.15</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* use ReactJSXRuntime for better WordPress 6.6 compatibility (CU-86959qqq1)</details>





## 0.1.18 (2024-08-01)


### Maintenance

* **deps :** update dependency php-stubs/wordpress-stubs to v6.6.0


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.11</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* implement a new event RCB/PreDecision/Promises to delay the cookie banner appearance programmatically (CU-86955u6k6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.13</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.9</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.14</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Code Refactoring

* react-sortable-hoc to dnd-kit (CU-awv3bv)
* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 0.1.6</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.5</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.3.3</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>





## 0.1.17 (2024-07-17)


### Bug Fixes

* no longer send referer via URL parameter as this lead to issues with Strato servers (dashboard no longer loads, CU-86954236z)







## 0.1.16 (2024-07-16)


### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)


<details><summary>Development dependency update @devowl-wp/api 0.5.24</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* suppress logs from requests from nullers (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* allow usesNonCookieAccess property in TCF vendor device disclosure (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.10</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.8</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)</details>





## 0.1.15 (2024-06-20)


### Bug Fixes

* base64 encode tests for the REST API endpoint test to avoid conflicts with search & replace (CU-8694uj43d)
* compatibility with WooCommerce Google Analytics and Google Consent Mode (CU-866avf01n)
* cURL operation timed out REST API notice and retry again after x seconds (CU-8694uj43d)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* **deps :** update dependency mpratt/embera to v2.0.40
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Development dependency update @devowl-wp/api 0.5.23</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.5</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.12</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.16</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.9</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.11</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.5.3</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.7</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)
* show correct text in second view (CU-8694vgm6z)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.12</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


##### Performance Improvements

* cookie edit form loads faster now when changing fields (CU-8694pd20a)
* cookie edit form loads faster now when changing fields (CU-8694pd20a)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 0.1.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.33</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.4</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.3.2</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.1.14 (2024-05-29)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.6</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* accessibility elements use prohibited aria attributes aria-labelledby (CU-8694k3zua)
* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)</details>





## 0.1.13 (2024-05-10)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* sticky legal link icon is not aligned correctly when bootstrap is in use (CU-8694dcmep)</details>





## 0.1.12 (2024-04-25)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.21</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introducing password login in rcb (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added moe supported languages (CU-86936my3v)
* disabled default lang edit, hide fields depending on translatable and extended merge strategy plus other fixes (CU-86936my3v)
* enabled statistics with allowedLanguages for translators, changed media permissions (CU-86936my3v)
* filter language select by role parameters (CU-86936my3v)
* introduce lastEditedBy field for templates (CU-86936my3v)
* introduce role parameters to users (CU-86936my3v)
* introducing form field wrapper with role based functionalities and used it for template forms (CU-86936my3v)
* introducing password login in rcb (CU-86936my3v)
* purpose translation variable validation and last editors (CU-86936my3v)
* rename route to user/password (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)
* move password route (CU-86936my3v)</details>





## 0.1.11 (2024-04-23)


### Bug Fixes

* consent types were recommended for Google Tag Manager service in notice (CU-8694art6m)


<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.9</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* write NulledVersionUsage deferred (CU-8694939q9)</details>





## 0.1.10 (2024-04-19)


### Bug Fixes

* do not show notice about Google Consent Mode and Tag Manager when identifier is gtm-1 (e.g. WPML/PolyLang, CU-8694art6m)


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)</details>





## 0.1.9 (2024-04-12)


### Bug Fixes

* deprecation warning in PHP log about Requests_Response class (CU-86949561p)
* the newly added notice about REST API shows errors about 403 Forbidden, we added another tip for the cause (CU-86949561p)







## 0.1.8 (2024-04-10)


### Bug Fixes

* show another tip about REST API issues when cURL throws an error (CU-86949561p)







## 0.1.7 (2024-04-09)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.5</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* cookie banner not shown in older Safari versions (Hotfix, CU-86947y4pv)</details>





## 0.1.6 (2024-04-09)


### Bug Fixes

* implement a mechanism detecting a defect Consent REST API and recommend knowledgebase articles (CU-8693zknc0)
* implement wait_for_update in Google Consent Mode to avoid issues with too early fired events (CU-86946wnva)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Bug Fixes

* scanner finds Google Maps for MyListing theme when Mapbox instead of Google Maps is used (CU-86947zz6j)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.12.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)


##### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.5</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* introduce a fallback system when the remote server is not available (CU-1xpcvre)
* reset all template fields in edit form</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.6.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)</details>





## 0.1.5 (2024-03-22)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.3</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.11.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)</details>





## 0.1.4 (2024-03-13)


### Bug Fixes

* undefined array key flag PHP warning


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.11.0</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* show service group with partial icon when a service with opt-out is configure (CU-86941b3h8)


##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.3</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* allow also to ignore/unignore service templates in scanner results (CU-31mh4np)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.5.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)


##### Styling

* break all links when viewport gets too small on mobile in second view of cookie banner</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.3.0</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)</details>





## 0.1.3 (2024-02-28)

**Note:** This package (@devowl-wp/cookie-consent-management) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.10.2</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* when changing consent and WordPress is too slow no changes are saved (CU-8693n1cc5)</details>





## 0.1.2 (2024-02-26)


### Bug Fixes

* 404 error in Consent Forwarding when GCM and TCF is deactivated (CU-8693265jz)


### Performance

* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)


### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* empty template name on release warning message (CU-8693uepwd)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner 0.10.1</summary>


**_Purpose of dependency:_** _Provide UI for a cookie banner and content blocker for multiple services._
##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/react-cookie-banner-admin 0.13.1</summary>


**_Purpose of dependency:_** _Provide admin UI for a cookie banner and content blocker for multiple services._
##### Bug Fixes

* errors were no longer shown in service edit form for technical definitions (CU-8693wmp4k)
* show a notice when activating GCM consent mode with Tag Manager integration when previsouly events were active (CU-8693wp05t)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/react-utils 0.1.2</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* cookie banner cannot be accepted on old Safari browsers (CU-8693u1wzm)


##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* render shortcodes async and add lazy-require() webpack plugin (CU-8693cqz75)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/web-cookie-banner 0.4.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Styling

* reset anchor / link styles in cookie banner correctly when theme overwrites it (CU-8693wx9ec)</details>

<details><summary>Development dependency update @devowl-wp/web-scoped-css 0.2.14</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)</details>





## 0.1.1 (2024-02-05)


### Refactoring

* introduce @devowl-wp/cookie-consent-management package (CU-apv5uu)
* move Google Consent Mode calculations to @devowl-wp/cookie-consent-management (CU-apv5uu)
