<?php
namespace DevOwl\CookieConsentManagement\settings;

/**
 * Abstract implementation of the settings for the cookie policy.
 */
abstract class AbstractCookiePolicy extends BaseSettings {
    /**
     * Instruction text.
     *
     * @return string
     */
    abstract public function getInstructionText();

    /**
     * Headline text for the table of contents.
     *
     * @return string
     */
    abstract public function getHeadlineTableOfContents();

    /**
     * Headline text for the website operator section.
     *
     * @return string
     */
    abstract public function getHeadlineControllerOfWebsite();

    /**
     * Headline text for diff to privacy policy section.
     *
     * @return string
     */
    abstract public function getHeadlineDiffToPrivacyPolicy();

    /**
     * Headline text for explaining cookie and cookie-like technology section.
     *
     * @return string
     */
    abstract public function getHeadlineCookieTechnology();

    /**
     * Legal explanation of cookies.
     *
     * @return string
     */
    abstract public function getHeadlineLegalBasis();

    /**
     * Information about the rights of the website visitor and function for viewing the history of consent, changing consent and revoking consent.
     *
     * @return string
     */
    abstract public function getHeadlineRightsOfTheVisitor();

    /**
     * Explanation of how to delete cookies in your browser (including 3rd party cookies that RCB cannot delete; no explanation per browser, but only generally necessary, about the browser manual).
     *
     * @return string
     */
    abstract public function getHeadlineManageCookies();

    /**
     * Types of cookies and their purposes.
     *
     * @return string
     */
    abstract public function getHeadlineTypesOfCookies();

    /**
     * Who can set cookies on websites?
     *
     * @return string
     */
    abstract public function getHeadlineCookieOrigin();

    /**
     * List of all services with their details.
     *
     * @return string
     */
    abstract public function getHeadlineListOfServices();

    /**
     * Content text for diff to privacy policy section.
     *
     * @return string
     */
    abstract public function getContentDiffToPrivacyPolicy();

    /**
     * Content text for cookie and cookie-like technology section.
     *
     * @return string
     */
    abstract public function getContentCookieTechnology();

    /**
     * Content text for legal basis section for the GDPR / ePrivacy Directive.
     *
     * @return string
     */
    abstract public function getContentLegalBasisGdpr();

    /**
     * Content text for legal basis section for the DSG (Switzerland).
     *
     * @return string
     */
    abstract public function getContentLegalBasisDsg();

    /**
     * Content text for rights of visitor section.
     *
     * @return string
     */
    abstract public function getContentRightsOfVisitor();

    /**
     * Content text for how to manage cookies section.
     *
     * @return string
     */
    abstract public function getContentManageCookies();

    /**
     * Content text for the types of cookies (list categories of cookies like Essential, Marketing, Functional, Statistics, ...).
     * You should also make use of `isShowCustomGroups()` to show an extra paragraph for custom groups.
     *
     * @return string
     */
    abstract public function getContentTypesOfCookies();

    /**
     * When there are custom groups created beside Essential, Marketing, Functional, Statistics, also show a static text about those groups.
     *
     * @return boolean
     */
    abstract public function isShowCustomGroups();

    /**
     * Content text for who is setting cookies section.
     *
     * @return string
     */
    abstract public function getContentCookiesOrigin();

    /**
     * In this text field, you can make additional additions to the cookie policy that do not fit any of the previously mentioned topics.
     *
     * Use `{{dateOfUpdate}}` as a placeholder to show date of the cookie policy when it was last changed.
     *
     * @return string
     */
    public function getAdditionalContent() {
        return '';
    }

    /**
     * Get label texts for the website operator details.
     *
     * @return array
     */
    abstract public function getControllerOfWebsiteLabels();

    /**
     * Get label texts for the table of list of services.
     *
     * @return array
     */
    abstract public function getListOfServicesTableColumnLabels();

    /**
     * Get language texts for the GridJS instance which formats the cookie policy to a nice table.
     *
     * @see https://github.com/grid-js/gridjs/blob/9a6a53eacdc019c01decfdfa8e77cb800922de3d/src/i18n/en_US.ts#L1C16-L22C2
     * @return array
     */
    abstract public function getGridJsLanguageTexts();

    /**
     * Render the GridJs table in dark mode.
     *
     * @return boolean
     */
    abstract public function isTableDarkMode();
}
