# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.4.2 (2026-01-23)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 1.4.1 (2026-01-20)


### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Tests

* content blocker JSON file was not found (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.3.2</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.20</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.21</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.2.1</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>





# 1.4.0 (2026-01-15)


### Bug Fixes

* allow to block elements with capitalized characters (CU-869bh2c93)
* compatibility with Fluent Calendar when not loading in frontend
* compatibility with PixelYourSite when pysOptions gets blocked (CU-869bra6kz)
* compatibility with WP Grid Builder and 'wpgb_settings is not defined' error


### Features

* implement SharedAtLeastOne plugin to merge required IDs across blockers using at-least-one logic (CU-f535x6)


### Maintenance

* code AI review (note 7021, CU-869bh2c93)
* code review AI (note 6992, CU-f535x6)
* remove package.json#engines from internal packages (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.3.1</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* allow to block elements with capitalized characters (CU-869bh2c93)
* in some cases content does not get unblocked when scripts without loading-semantics need to be unblocked first (CU-869brj1eb)


##### Maintenance

* code AI review (note 7021, CU-869bh2c93)
* remove package.json#engines from internal packages (CU-86931jwau)</details>





## 1.3.15 (2025-12-10)


### Bug Fixes

* compatibility with latest Bricks Builder when using Google Maps
* compatibility with SolidSecurity reCaptcha, hCaptcha and Cloudflare Turnstile (CU-869apt3a0)


### Tests

* add HTML fixture for script module consent handling (CU-869be7jn7)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.3.0</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Features

* add support for script modules in content blocker (CU-869be7jn7)</details>





## 1.3.14 (2025-12-04)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/vitest-config 0.2.0</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Features

* inital implementation of object-storage package (CU-8697h8axv)</details>





## 1.3.13 (2025-11-21)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 1.3.12 (2025-10-15)


### Bug Fixes

* compatibiltiy with Total WP Theme and blocking lightboxes


<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 1.3.11 (2025-09-24)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.24</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* correctly handle objects in JSON (CU-869aga17c)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 1.3.10 (2025-09-04)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.23</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* modifyAny should return an object/array if passed as object/array (CU-1y25df6)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





## 1.3.9 (2025-08-08)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)</details>





## 1.3.8 (2025-07-29)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.3.7 (2025-07-18)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>





## 1.3.6 (2025-07-10)


### Bug Fixes

* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)
* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)
* support webp images for image preview files


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.19</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* deprecation notice in PHP 8.4 for utf8_decode (CU-8699fymmg)
* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.19</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.20</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Tests

* skip type files in coverage (CU-8698r80f9)</details>





## 1.3.5 (2025-07-02)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.







## 1.3.4 (2025-06-25)


### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


### Tests

* concurrent test execution and test isolation (CU-8698r80f9)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.17</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


##### Tests

* concurrent test execution and test isolation (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.11</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>





## 1.3.3 (2025-06-11)


### Bug Fixes

* compatibility with false positive scanner result for Google Content in WP Amelia
* do not recommend Google Fonts when using new version of OMGF (CU-861mdaurx)
* vue-specific attributes in combination with DoNotBlockScriptTemplate plugin (CU-86998q97k)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.16</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* vue-specific attributes in combination with DoNotBlockScriptTemplate plugin (CU-86998q97k)</details>





## 1.3.2 (2025-05-15)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.10</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.3.1 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.14</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.18</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.9</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





# 1.3.0 (2025-05-06)


### Bug Fixes

* compatibility with latest FluentCommunity version


### Features

* introduce sorter mechanism for blockables with predefined priority (CU-8698wyny4)







## 1.2.11 (2025-04-25)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.2.10 (2025-04-17)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.7</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Maintenance

* added debug section (CU-8697hhm6p)</details>





## 1.2.9 (2025-04-14)


### Bug Fixes

* calendly was found as external URL and service when it has a style attribute (CU-8698mqkuy)







## 1.2.8 (2025-04-08)


### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.6</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 1.2.7 (2025-04-02)


### Bug Fixes

* invalid service template opt-in code when using Referrer-Policy: origin (CU-8698jkz8y)
* isolate the query validation on a per-scan-entry basis (CU-86980mzm5)


### Code Refactoring

* clean up false positive processor (CU-86980mzm5)


### Performance Improvements

* consider blockables only relevant for an external URL instead of using all (CU-86980mzm5)
* do not scan already notified service templates (CU-86980mzm5)
* false positive processor optimization when checking thousands of scan entries (CU-86980mzm5)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.10</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* invalid service template opt-in code when using Referrer-Policy: origin (CU-8698jkz8y)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Code Refactoring

* clean up false positive processor (CU-86980mzm5)


##### Tests

* copy webgrind files individually (CU-86980mzm5)</details>





## 1.2.6 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.9</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.5</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 1.2.5 (2025-03-04)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>





## 1.2.4 (2025-02-25)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.2.3 (2025-02-24)


### Bug Fixes

* recommend WordPress comments only when necessary (CU-863h7mbwk)







## 1.2.2 (2025-02-20)


### Bug Fixes

* autoplay videopress embed on unblock (CU-8697ynbqy)
* correctly block custom web elements by modifying the end tag correctly (CU-8697zc5r2)
* correctly match selector syntax rules when also StyleInlineMatcher matches on the element (CU-8697pthng)
* pinterest embed code got found as external URL instead of template (CU-8697ze2yw)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.6</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* correctly block custom web elements by modifying the end tag correctly (CU-8697zc5r2)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.3</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Bug Fixes

* added types to excludes for vitest (CU-8697hhm6p)</details>





## 1.2.1 (2025-02-17)


### Maintenance

* upgrade to PNPM 10 (CU-8697je0ta)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.5</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Maintenance

* upgrade to PNPM 10 (CU-8697je0ta)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* upgrade to PNPM 10 (CU-8697je0ta)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.1.2</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Maintenance

* upgrade to PNPM 10 (CU-8697je0ta)</details>





# 1.2.0 (2025-02-06)


### Bug Fixes

* compatibility with Bricks Builder and iframe embeds


### Features

* allow to configure global styles in style selector syntax function (CU-86971x71q)
* introduce new selector syntax function jQueryHijackFn to hijack jQuery functions (CU-8697ptyry)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.4</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* deprecation notice for strpos in SelectorSyntaxAttribute (CU-344wg4f)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 1.1.4 (2025-01-14)


### Bug Fixes

* allow wildcard-tag with asterisk in selector syntax (CU-gt22gk)
* new plugin method beforeSetBlockedInResult (CU-8696heugb)


### Maintenance

* make processMatch public method (CU-8696heugb)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.3</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* allow selector syntax attributes matching quotes with backslashed quotes (CU-gt22gk)
* allow wildcard-tag with asterisk in selector syntax (CU-gt22gk)


##### Maintenance

* remove console.log (CU-8696heugb)</details>





## 1.1.3 (2024-12-09)


### Performance Improvements

* speed up HTML parsing and blocking (CU-8696x8wm0)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.2</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* blank page on some pages with low memory (CU-8696x8wm0)


##### Performance Improvements

* speed up HTML parsing and blocking (CU-8696x8wm0)</details>





## 1.1.2 (2024-12-07)


### Bug Fixes

* blank page on some pages with low memory (CU-8696x8wm0)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.1</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* blank page on some pages with low memory (CU-8696x8wm0)</details>





## 1.1.1 (2024-12-06)


### Bug Fixes

* allow to block by blockable rule on already blocked tag attribute (CU-8696vyeen)
* compatibility with ACF Frontend Form for Dynamicooo (CU-8696rw241)
* compatibility with Cinerama theme
* scan and block <video and <audio with src attribute (CU-8696vyeen)
* vueJS templates did not longer work when they included a single quote and greater character (CU-8696x8wm0)


### Code Refactoring

* make selector syntax map reliably work for already blocked items (CU-8696rw241)


### Performance Improvements

* allow profiling PHPUnit tests via webgrind (CU-8696qqa89)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.2.0</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Bug Fixes

* html attributes can also contain hashes (CU-8696x8wm0)
* vueJS templates did not longer work when they included a single quote and greater character (CU-8696x8wm0)


##### Code Refactoring

* make selector syntax map reliably work for already blocked items (CU-8696rw241)


##### Features

* allow to lock attributes so they can no longer be modified (CU-8696rw241)


##### Performance Improvements

* allow profiling PHPUnit tests via webgrind (CU-8696qqa89)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Performance Improvements

* allow profiling PHPUnit tests via webgrind (CU-8696qqa89)</details>





# 1.1.0 (2024-11-19)


### Features

* never apply content blocker to <template HTML tags (CU-8696jdgn1)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.1.0</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Features

* never apply content blocker to <template HTML tags (CU-8696jdgn1)</details>





## 1.0.1 (2024-11-11)


### Bug Fixes

* the PSR-0 Requests_... class names in the Requests library are deprecated (CU-8696jfb32)







# 1.0.0 (2024-11-07)


### Bug Fixes

* block video poster correctly (CU-8696gf2kg)
* do not find data URLs as external URL (CU-8695mtnyu)


### Maintenance

* initial release (CU-869656drt)


### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.


<details><summary>Dependency updates @devowl-wp/fast-html-tag 1.0.0</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>





## 0.18.2 (2024-10-23)


### Bug Fixes

* always show original markup in scan entries and deduplicate (CU-86969de1q)
* fatal error: Uncaught Error: Call to a member function getRegularExpressions() on null (CU-8695yj3g9)
* streamline common Vimeo and YouTube content blocker rules to new selector syntax map functionality (CU-86964vzn3)


### Code Refactoring

* move WordPress content blocker compatibility tweaks to isomorphic package (CU-8695mtnyu)
* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)


<details><summary>Dependency updates @devowl-wp/fast-html-tag 0.11.2</summary>


**_Purpose of dependency:_** _Find tags within HTML content and modify it in speed of light_
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.17</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>





## 0.18.1 (2024-09-26)


### Bug Fixes

* compatibility with Gutenberg vimeo embeds with direct URLs instead of player.vimeo.com (CU-8695jrnud)
* compatibility with SiteGround Optimizer and minificdation of files (CU-8695rputb)
* show a notice when a new service template covers an external URL (CU-86955xtbe)
* track rules which match the same inline script in scanner correctly (CU-86942x07f)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>





# 0.18.0 (2024-08-01)


### Features

* allow to configure variables for selector syntax functions (CU-86954w4j6)
* new selector syntax function eval() (CU-86954w4j6)


### Maintenance

* **deps :** update dependency php-stubs/wordpress-stubs to v6.6.0







# 0.17.0 (2024-07-16)


### Bug Fixes

* do not loop Vimeo embeds when unblocking through content blocker (CU-8695141bx)


### Features

* allow to use selector syntax attribute functions through selector syntax map for already blocked elements (CU-8695141bx)







## 0.16.11 (2024-06-20)


### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* **deps :** update dependency mpratt/embera to v2.0.40
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.16</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.16.10 (2024-05-29)


### Bug Fixes

* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)
* allow to use confirm() and delegateClick() together (CU-8694myd2d)
* matchesUrl() should also work with addSelectorSyntaxMap() (CU-8694jz55m)







## 0.16.9 (2024-05-10)


### Bug Fixes

* apply inline script plugins also to scripts with base64-encoded data URL as src (CU-8694ge2gj)
* compatibility with AI Assistant with ChatGPT by AYS (CU-8694f00cj)







## 0.16.8 (2024-04-10)


### Bug Fixes

* uppercase <A tag leads to scanner results (CU-869496hwj)


### Testing

* rename test (CU-869496hwj)







## 0.16.7 (2024-04-09)


### Bug Fixes

* correctly block link HTML tags with multiple rels (CU-86945vky4)
* scanner finds Google Maps for MyListing theme when Mapbox instead of Google Maps is used (CU-86947zz6j)


<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Bug Fixes

* scanner finds Google Maps for MyListing theme when Mapbox instead of Google Maps is used (CU-86947zz6j)</details>





## 0.16.6 (2024-03-13)


### Bug Fixes

* allow also to ignore/unignore service templates in scanner results (CU-31mh4np)







## 0.16.5 (2024-02-26)


### Bug Fixes

* strtolower(): Passing null to parameter [#1](https://git.devowl.io/devowlio/devowl-wp/issues/1) () of type string is deprecated (CU-863gympe9)
* uncaught TypeError: Cannot access offset of type string on string TcfVendorDomainsBlockable.php


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>





## 0.16.4 (2024-02-05)


### Bug Fixes

* compatibility with embed HTML tags (CU-8693p91em)


### Refactoring

* move Google Consent Mode calculations to @devowl-wp/cookie-consent-management (CU-apv5uu)







## 0.16.3 (2024-01-25)


### Bug Fixes

* add autoplay to wistia.net (CU-8693jdhgk)
* extract external URL from inline script of TradeTracker (CU-8693jrh8f)


<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>





## 0.16.2 (2024-01-18)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 0.16.1 (2024-01-05)


### Bug Fixes

* never touch internal links when forwarding TCF consent string via link (CU-8693cyetg)







# 0.16.0 (2024-01-04)


### Bug Fixes

* correctly deduplicate Elementor Forms with Google reCaptcha (CU-8693e1f9x)


### Features

* introduce new plugin hook setup() (CU-8693cyetg)
* introduce TcfForwardGdprStringInUrl plugin (CU-8693cyetg)







## 0.15.2 (2023-12-21)


### Bug Fixes

* correctly implement the usage of rules and rule groups (CU-8693a7gmn)


### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)


### Testing

* update available content blockers from service cloud


<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.12</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>





## 0.15.1 (2023-12-19)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





# 0.15.0 (2023-12-15)


### Bug Fixes

* compatibility with Beaver Builder and the option to render assetes inline (CU-8693992x4)


### Features

* allow to negate rules with a prefixed exclamation mark (CU-869387nbx)
* allow to set required purposes for TCF content blockers (CU-86933edy3)







## 0.14.8 (2023-11-28)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>





## 0.14.7 (2023-11-24)


### Bug Fixes

* do not find link with rel me and alternate as external URL in scanner (CU-2f7ccf4)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>





## 0.14.6 (2023-11-16)


### Bug Fixes

* podigee player did not get blocked correctly (CU-86934av6a)







## 0.14.5 (2023-11-02)


### Bug Fixes

* commented out inline script should not get mixed with external scripts when blocking content (CU-869314r0e)
* do not override script type attribute value as some services are not compatible with the standards (CU-8692xx4j4)
* passing null to parameter [#1](https://git.devowl.io/devowlio/devowl-wp/issues/1) () of type string is deprecated
* passing null to parameter [#1](https://git.devowl.io/devowlio/devowl-wp/issues/1) () of type string is deprecated (CU-86930u18a)


### Documentation

* update PHPDoc for selector syntax functions







## 0.14.4 (2023-10-27)


### Documentation

* better explain the expression schema for ScriptInlineJsonBlocker (CU-8693098ra)


### Maintenance

* remove unwanted error_log (CU-8693098ra)


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>





## 0.14.3 (2023-10-12)


### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* major update webpack components (CU-3cj43t)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>





## 0.14.2 (2023-09-29)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)





## 0.14.1 (2023-08-28)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.14.0 (2023-08-24)


### feat

* introduce new confirm() selector-syntax rule for content blockers (CU-861n86a5n)
* introduce new selector syntax function transformAttribute (CU-861n7upvp)


### fix

* keep attributes if configured for loading attributes (CU-861n86a5n)


### test

* added tests for confirm plugin (CU-861n86a5n)





## 0.13.2 (2023-08-02)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.13.1 (2023-07-18)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.13.0 (2023-07-06)


### feat

* allow to exclude matches from DoNotBlockScriptTextTexmplates (CU-863h5dak1)


### fix

* scanner did not find inline script of Plerdy (CU-863h3vngv)


### refactor

* introduce custom ESLint rules ability in @devowl-wp/eslint-config (CU-863gxjbn4)





## 0.12.7 (2023-05-30)


### fix

* allow URLs without scheme in Autoplay plugin (CU-863gvntu4)


### refactor

* connect new template center with scanner (WIP, CU-861me62d8)


### test

* introduce tests (CU-3207gvx)





## 0.12.6 (2023-05-22)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.12.5 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





## 0.12.4 (2023-05-15)


### fix

* font-face was no longer extracted completely (CU-863gp7hfb)
* vimeo private video cannot get download preview image (CU-861mtjmab)





## 0.12.3 (2023-05-11)


### perf

* speed up removal of non-blocked rules from extracted document (CU-863gp7hfb)





## 0.12.2 (2023-04-24)


### fix

* scanner did no longer work as expected for some subpages (CU-863ghxta5)





## 0.12.1 (2023-04-19)


### fix

* add multiple blockables to BlockedResult when requested (CU-863gdnt50)
* compatibility with latest RankMath version and finding Google Analytics UA and v4 with local script files enabled (CU-863gdnt50)


### refactor

* introduce taskfile.dev Taskfiles (CU-85zrrymj0)
* rename doNotConsiderInGroups to needsRequiredSiblingRule (CU-863gdnt50)





# 0.12.0 (2023-03-24)


### feat

* introduce new selector syntax function jQueryHijackEach (CU-863gac0ng)





## 0.11.4 (2023-03-21)


### chore

* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)


### fix

* do not remove link preloads with onload attribute (CU-85zrrp9u6)





## 0.11.3 (2023-03-14)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.11.2 (2023-02-28)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.11.1 (2023-02-15)


### fix

* new selector syntax function to delegate a click on blocked node (CU-863g124r8)





# 0.11.0 (2023-01-25)


### feat

* introduce per-match plugin callbacks (CU-33z67qt)
* new selector syntax function keepAttributes (CU-33z67qt)
* new selector syntax function style (CU-33z67qt)
* new selector syntax functions forceVisual() and visualParent() (CU-33z67qt)


### fix

* compatibility with Breakdance page builder and Goolge Maps embeds (CU-33z67qt)
* compatibility with Breakdance page builder and YouTube embeds (CU-33z67qt)
* compatibility with Enfold and performance JavaScript mreging (CU-861m8g071)





# 0.10.0 (2022-12-22)


### chore

* update all package.json to resolve release conflicts (CU-382p4kb)


### feat

* support for data URL transformations (CU-388ak7a)


### fix

* warning trying to access offset on value of type null in PHP log (CU-861m47fm0)


### perf

* remove path_join calls and use trailingslashit instead (CU-861m3qqb7)





## 0.9.1 (2022-12-12)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.9.0 (2022-11-24)


### feat

* introduce new selector syntax for custom functions (CU-33z3dh8)


### fix

* introduce new content blocker selector syntax matchUrls to fix false-positive Elementor videos (CU-33z3dh8)





## 0.8.2 (2022-11-15)


### fix

* php notice about blockable variable is not defined (CU-33kfj43)





## 0.8.1 (2022-10-31)


### fix

* check selector syntax attributes for selector syntax map (CU-32pvhdp)





# 0.8.0 (2022-10-25)


### feat

* allow to define a consent-click-dispatch-resize attribute to dispatch resize event after click (CU-3204cj6)
* allow to define blockable candidates by selector syntax (CU-3204cj6)





## 0.7.5 (2022-10-11)


### build

* add webpack as dependency to make it compatible with PNPM (CU-3rmk7b)


### chore

* introduce consistent type checking for all TypeScript files (CU-2eap113)
* prepare script management for self-hosted Gitlab migrations (CU-2yt2948)
* start introducing common webpack config for frontends (CU-2eap113)


### fix

* compatibility with Divi multi view and allow deeply blocking content in JSON attributes (CU-30jcz089)
* compatibility with Impreza + WP Bakery vimeo embed and video thumbnail (CU-2yyye6w)
* memory leak when using Gravity Forms with Google reCAPTCHA and try to scan that form (CU-306w113)





## 0.7.4 (2022-09-16)


### fix

* compatibility with BeaverBuilder PowerPack videos and overlays (CU-2yyvjag)





## 0.7.3 (2022-09-06)


### fix

* block inline style attributes more accurate (CU-2wmft3q)
* font-face (e.g. FontAwesome) gets blocked correctly but not unblocked (CU-2wmft3q)
* split TagAttributeFinder in multiple regular expressions to find multiple blockable attributes (CU-2x5hpdz)
* youtube video thumbnails downloader with youtube IDs with dashes





## 0.7.2 (2022-08-29)


### chore

* introduce devowl-scripts binary (CU-2n41u7h)
* introduce for non-flat node_modules development experience (CU-2n41u7h)
* prepare packages for PNPM isolated module mode (CU-2n41u7h)


### fix

* remove form action attribute as external URL in scanner results (CU-2vqxxxw)
* sometimes Custom HTML blocks got no YouTube thumbnail and block iframe onload attribute (CU-2wetw74)





## 0.7.1 (2022-08-09)


### fix

* compatibility with vanilla-lazyload used by WP Rocket Lazy Load plugin (CU-2pc568x)
* download videopress thumbnail (CU-2r585z9)
* read thumbnail URL from JSON attribute (CU-2rw9wbd)
* soundcloud player API URLs of tracks (CU-2r5eqdb)
* using custom WP_CONTENT_DIR for wp-content/plugins and wp-content/themes blocker rules (CU-2rb3arg)





# 0.7.0 (2022-07-06)


### feat

* allow to block content of custom elements (web components, CU-2nfkhc3)


### fix

* allow to block JSON in inline scripts granularly (e.g. inline translations, CU-2my9x5r)
* compatibility with RankMath SEO and Google Analytics GA4 property (CU-2je6juk)





## 0.6.5 (2022-06-13)


### fix

* compatibility with Vimeo private videos and content blocker download thumbnails (CU-2kgpmnk)





## 0.6.4 (2022-06-08)


### chore

* update embera third-party dependency (CU-2d2n29v)


### fix

* security vulnerability XSS, could be exploited by logged in administratos (CU-2j8f5fa)





## 0.6.3 (2022-05-24)


### fix

* contact form 7 showed up without any Google reCAPTCHA script (CU-2eghepk)
* lock presets with non-matching groups in scanner to avoid reassigned to the preset in another false-positive mechanism (CU-2eghepk)
* preview images for youtube-nocookie.com embeds (CU-2f1fcfv)
* redesign false-positive mechanism in scanner for must-groups (CU-2eghepk)
* scanner should remove external URLs which are already duplicated in a found preset (CU-2eghepk)


### refactor

* namings for headless-content-blocker scan options (CU-2eghepk)





## 0.6.2 (2022-05-09)


### fix

* avoid already scanned elements as duplicate founds (CU-2dkvyrh)





## 0.6.1 (2022-04-29)


### fix

* compatibility with api.soundcloud.com (CU-2d2pahk)
* compatibility with podcaster.de and podcast-player plugin (CU-2d89n4c)
* do not show dns prefetch in external URLs (CU-22h5xz6)
* never block any dns-prefetch link tags as they are GDPR compliant without any blocking (CU-22h5xz6)
* omit unnecessery link tags (CU-2cwz5v4)





# 0.6.0 (2022-04-20)


### chore

* implement UI for new content blocker visual settings (CU-eb4h2q9)
* update embera (CU-eb4h2q)


### feat

* allow content blocker with preview images in List of consents (CU-eb4h2q)


### fix

* allow to download alternative thumbnails if the first one is not available (CU-eb4h2q)
* compatibility with Thrive Architect when using nested vimeo embeds (CU-eb4h2q)
* download thumbnail in standard format and force 16/9 ratio for YouTube videos (CU-eb4h2q)
* hero content blocker with style attribute not correctly blocked (CU-1zvgm2h)
* improved compatibility with Podigee (CU-eb4h2q)
* improved compatibility with WP YouTube Lyte (CU-eb4h2q)
* relate blockable instance to thumbnail (CU-eb4h2q)
* when content blocker got called multiple times respect found URL in ImagePreview (CU-eb4h2q)


### refactor

* extract composer dev dependencies to their corresponding dev package (CU-22h231w)
* move wordpress packages to isomorphic-packages (CU-22h231w)
* put composer license packages to @devowl-wp/composer-licenses (CU-22h231w)
* revert empty commits for package folder rename (CU-22h231w)





## 0.5.2 (2022-03-15)


### chore

* use wildcarded composer repository path (CU-1zvg32c)





## 0.5.1 (2022-03-01)


### fix

* allow to apply code dynamics to code on page load (CU-1wernq1)
* allow to block all elements via SelectorSyntax even if already blocked (CU-1yyxmwn)
* better memory allocation for scanner and persisting found markups to database (CU-1ydq6ff)
* block CSS styles in style-attributes of HTML elements (CU-1ydpqa1)
* correctly show Blocked URL in scanner results for inline styles (CU-1ydq6ff)
* do not find canoncial links as external URL (CU-1z4gxq1)
* do not scan link rel=shortlink as it does not process any data (CU-1yt2qzj)
* find external URLs again (CU-1ydq6ff)
* google analytics was shown as external URL when using single gtag/js UA integration (CU-1yt64aa)





# 0.5.0 (2022-01-31)


### chore

* clean up and refactor coding for image preview / thumbnails (WIP, CU-1w3c9t7)


### feat

* host scan options could have multiple must-groups to resolve (CU-1vqx293)
* new plugin to extract image preview / thumbnails from embed URLs (CU-1w3c9t7)


### fix

* found Google Trends in scanner when using Google reCAPTCHA standalone (CU-1zgh14v)
* scanner query validation should also work for encoded strings (CU-1vqx293)


### refactor

* remove defined in each file header to make it testable





## 0.4.1 (2022-01-25)

**Note:** This package (@devowl-wp/headless-content-blocker) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.4.0 (2022-01-17)


### build

* create cachebuster files only when needed, not in dev env (CU-1z46xp8)
* improve build and CI performance by 50% by using @devowl-wp/regexp-translation-extractor (CU-1z46xp8)


### feat

* allow multiple attributes in SelectorSyntaxFinder (CU-1wecmxt)


### fix

* compatibility with a3 Lazy Load (CU-22gym0m)
* empty external URL shown when plugin Disable WordPress Emojis is active (CU-1y7rr78)
* in some cases googletagmanager.com was stated as external URL (CU-1zfmt8z)
* sometimes CSS stylings got fonud as external URL (e.g. opacity:0, CU-1y7nren)


### refactor

* move scanner to @devowl-wp/headless-content-blocker package (CU-1xw52wt)


### test

* compatibility with Xdebug 3 (CU-1z46xp8)





# 0.3.0 (2021-12-15)


### feat

* new plugin ScriptInlineExtractExternalUrl (CU-1v6cf91)


### fix

* avoid consent-inline to be empty when blocked multiple times (CU-1xaz9aw)
* support URLs without scheme for ScriptInlineExtractExternalUrl plugin (CU-1v6cf91)


### perf

* speed up scanner up to 300 % (CU-1xpd4z4)





## 0.2.2 (2021-11-24)


### fix

* inline scripts with more than 8,000 characters (depending on env) are not blocked (CU-1u3zb5b)





## 0.2.1 (2021-11-12)


### fix

* **critical :** server error when inline style found as blockable, but no URL got blocked inside rules (CU-1rvx2h3)





# 0.2.0 (2021-11-11)


### chore

* remove not-finished translations from feature branches to avoid huge ZIP size (CU-1rgn5h3)


### feat

* allow to calculate unique keys for (blocked) tags
* introduce DoNotBlockScriptTextTemplates plugin (CU-1qe7t0t)
* introduce new afterSetup callback


### fix

* consider line breaks in content blocker attributes (CU-1nfe6kd)
* correctly block inline style when using selector syntax (CU-1nfazd0)


### refactor

* extract content blocker to own package @devowl-wp/headless-content-blocker (CU-1nfazd0)
