<?php
namespace DevOwl\HeadlessContentBlocker\plugins\imagePreview;

use DevOwl\FastHtmlTag\finder\match\AbstractMatch;
use DevOwl\HeadlessContentBlocker\BlockedResult;

/**
 * Provide an interface and mechanism to determine if a blockable should load a thumbnail via `ImagePreview`.
 */
interface ImagePreviewBlockable {
    /**
     * Determine if a thumbnail / image preview should be downloaded for this match.
     *
     * @param string $url
     * @param BlockedResult $result
     * @param AbstractMatch $match
     * @return boolean
     */
    public function downloadImagePreviewFor($url, $result, $match);
}
