<?php
namespace DevOwl\HeadlessContentBlocker\plugins\selectorSyntaxFunction;

use DevOwl\FastHtmlTag\finder\match\AbstractMatch;
use DevOwl\FastHtmlTag\finder\SelectorSyntaxAttributeFunction;
use DevOwl\HeadlessContentBlocker\AbstractPlugin;
use DevOwl\HeadlessContentBlocker\Constants;
use DevOwl\HeadlessContentBlocker\finder\match\MatchPluginCallbacks;

/**
 * This plugin registers the selector syntax `jQueryHijackEach()`.
 *
 * ```
 * div[class="my-class":keepAttributes(value=class),jQueryHijackEach()]
 * ```
 *
 * When you use `jQuery.each()` on a specific selector (in this case `.my-class`), using `jQueryHijackEach` will "delay"
 * the execution of the callback until consent is obtained.
 */
class JQueryHijackEach extends AbstractPlugin {
    // Documented in AbstractPlugin
    public function init() {
        $this->getHeadlessContentBlocker()->addSelectorSyntaxFunction('jQueryHijackEach', [$this, 'fn']);
    }

    /**
     * Function implementation.
     *
     * @param SelectorSyntaxAttributeFunction $fn
     * @param AbstractMatch $match
     * @param mixed $value
     */
    public function fn($fn, $match, $value) {
        MatchPluginCallbacks::getFromMatch($match)->addBlockedMatchCallback(function ($result) use ($match) {
            if ($result->isBlocked()) {
                $match->setAttribute(Constants::HTML_ATTRIBUTE_JQUERY_HIJACK_EACH, true);
            }
        });
        return true;
    }
}
