<?php
namespace DevOwl\ServiceCloudConsumer\consumer;

use DevOwl\ServiceCloudConsumer\middlewares\ExistsMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\OneOfMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\ScanResultsMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\services\CdnMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\services\GroupMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\services\ManagerMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\services\ServiceAvailableBlockerTemplatesMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\services\TechnicalDefinitionsMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\SuccessorMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\VarMiddleware;
use DevOwl\ServiceCloudConsumer\middlewares\VersionsMiddleware;
use DevOwl\ServiceCloudConsumer\templates\ServiceTemplate;

/**
 * Predefined service cloud consumer for `ServiceTemplate` with all required middlewares registered.
 */
class ServiceConsumer extends ServiceCloudConsumer {
    /**
     * C'tor.
     */
    public function __construct() {
        parent::__construct(ServiceTemplate::class);

        $this->addMiddleware(new ExistsMiddleware($this));
        $this->addMiddleware(new OneOfMiddleware($this));
        $this->addMiddleware(new ManagerMiddleware($this));
        $this->addMiddleware(new ServiceAvailableBlockerTemplatesMiddleware($this));
        $this->addMiddleware(new VarMiddleware($this));
        $this->addMiddleware(new TechnicalDefinitionsMiddleware($this));
        $this->addMiddleware(new GroupMiddleware($this));
        $this->addMiddleware(new ScanResultsMiddleware($this));
        $this->addMiddleware(new VersionsMiddleware($this));
        $this->addMiddleware(new SuccessorMiddleware($this));
        $this->addMiddleware(new CdnMiddleware($this));
    }
}
