<?php
namespace DevOwl\ServiceCloudConsumer\middlewares\blocker;

use DevOwl\ServiceCloudConsumer\middlewares\AbstractTemplateMiddleware;
use DevOwl\ServiceCloudConsumer\templates\AbstractTemplate;
use DevOwl\ServiceCloudConsumer\templates\BlockerTemplate;

/**
 * Middleware to remove some `attributes` in free content blocker presets which are only available in PRO.
 */
class DisableProFeaturesInFreeMiddleware extends AbstractTemplateMiddleware {
    // Documented in AbstractTemplateMiddleware
    public function beforePersistTemplate($template, &$allTemplates) {
        if ($template instanceof BlockerTemplate) {
            if ($this->getVariableResolver()->resolveRequired('tier') === AbstractTemplate::TIER_FREE) {
                $template->visualType = null;
            }
        }
    }

    // Documented in AbstractTemplateMiddleware
    public function beforeUsingTemplate($template) {
        // Silence is golden.
    }
}
