/**
 * @see https://stackoverflow.com/a/6944961/5506547
 * @see https://regex101.com/r/wLTlSe/1
 */
const REGEXP_URL_PATH = /.+?:\/\/.+?(\/.+?)(?:#|\?(.*)|$)/;

/**
 * Get path of (sitemap) URL as we do not rely on the received host.
 *
 * - site got cloned with WP Duplicator -> wrong host in robots.txt if not yet flushed
 * - General > Settings is configured with `http` but site is served with `https`
 */
function mapUrlToRootUrl(rootUrl: string, receivedUrl: string, query = "") {
    const rootUrlPath = rootUrl.match(REGEXP_URL_PATH)?.[1] || "/";
    const match = receivedUrl.match(REGEXP_URL_PATH);
    if (match) {
        const [, path, receivedQuery] = match; // e.g. `/sitemap.xml`, `my-param=1`
        const useQuery = receivedQuery ? `?${receivedQuery}${query ? `?${query}` : ""}` : query ? `?${query}` : "";
        return `${rootUrl}${path.substr(rootUrlPath.length)}${useQuery}`;
    }

    return false;
}

export { mapUrlToRootUrl };
